/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import net.hasor.dataql.Finder;
import net.hasor.dataql.Query;
import net.hasor.dataql.compiler.qil.CompilerContext;
import net.hasor.dataql.compiler.qil.CompilerEnvironment;
import net.hasor.dataql.compiler.qil.InstQueue;
import net.hasor.dataql.compiler.qil.Instruction;
import net.hasor.dataql.compiler.qil.QIL;
import net.hasor.dataql.parser.DataQLLexer;
import net.hasor.dataql.parser.DataQLParser;
import net.hasor.dataql.parser.DefaultDataQLVisitor;
import net.hasor.dataql.parser.QueryModel;
import net.hasor.dataql.parser.QueryParseException;
import net.hasor.dataql.parser.ThrowingErrorListener;
import net.hasor.dataql.parser.ast.inst.RootBlockSet;
import net.hasor.dataql.runtime.CompilerArguments;
import net.hasor.dataql.runtime.QueryImpl;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class QueryHelper {
    public static QueryModel queryParser(String queryString) throws IOException {
        return QueryHelper.queryParser(new StringReader(queryString));
    }

    public static QueryModel queryParser(Reader queryReader) throws IOException {
        return QueryHelper.queryParser((CharStream)CharStreams.fromReader((Reader)queryReader));
    }

    public static QueryModel queryParser(InputStream queryInput) throws IOException {
        return QueryHelper.queryParser(queryInput, StandardCharsets.UTF_8);
    }

    public static QueryModel queryParser(InputStream inputStream, Charset charset) throws IOException {
        return QueryHelper.queryParser(CharStreams.fromStream((InputStream)Objects.requireNonNull(inputStream), (Charset)charset));
    }

    public static QueryModel queryParser(CharStream charStream) throws QueryParseException {
        DataQLLexer lexer = new DataQLLexer(charStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
        DataQLParser qlParser = new DataQLParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        qlParser.removeErrorListeners();
        qlParser.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
        DefaultDataQLVisitor visitor = new DefaultDataQLVisitor();
        return (RootBlockSet)visitor.visit((ParseTree)qlParser.rootInstSet());
    }

    public static QIL queryCompiler(String queryString, Finder importFinder) throws IOException {
        return QueryHelper.queryCompiler(QueryHelper.queryParser(queryString), CompilerArguments.DEFAULT, importFinder);
    }

    public static QIL queryCompiler(Reader queryReader, Finder importFinder) throws IOException {
        return QueryHelper.queryCompiler(QueryHelper.queryParser(queryReader), CompilerArguments.DEFAULT, importFinder);
    }

    public static QIL queryCompiler(InputStream queryInput, Finder importFinder) throws IOException {
        return QueryHelper.queryCompiler(QueryHelper.queryParser(queryInput, StandardCharsets.UTF_8), CompilerArguments.DEFAULT, importFinder);
    }

    public static QIL queryCompiler(InputStream queryInput, Charset charset, Finder importFinder) throws IOException {
        return QueryHelper.queryCompiler(QueryHelper.queryParser(queryInput, charset), CompilerArguments.DEFAULT, importFinder);
    }

    public static QIL queryCompiler(QueryModel queryModel, CompilerArguments compilerArguments, Finder importFinder) throws IOException {
        RootBlockSet rootBlockSet = null;
        rootBlockSet = queryModel instanceof RootBlockSet ? (RootBlockSet)queryModel : (RootBlockSet)QueryHelper.queryParser((CharStream)CharStreams.fromString((String)queryModel.toQueryString()));
        Set<String> compilerVar = (compilerArguments = compilerArguments == null ? CompilerArguments.DEFAULT : compilerArguments).getCompilerVar();
        if (compilerVar == null) {
            compilerVar = Collections.emptySet();
        }
        InstQueue queue = new InstQueue(compilerArguments);
        CompilerContext compilerContext = new CompilerContext(new CompilerEnvironment(importFinder));
        HashMap<String, Integer> compilerVarMap = new HashMap<String, Integer>();
        compilerVar.forEach(var -> {
            int localIdx = compilerContext.push((String)var);
            compilerVarMap.put((String)var, localIdx);
        });
        compilerContext.findInstCompilerByInst(rootBlockSet).doCompiler(queue);
        Instruction[][] queueSet = queue.buildArrays();
        return new QIL(queueSet, compilerVarMap);
    }

    public static Query createQuery(String queryString, Finder finder) throws IOException {
        return QueryHelper.createQuery(QueryHelper.queryCompiler(queryString, finder), finder);
    }

    public static Query createQuery(Reader queryReader, Finder finder) throws IOException {
        return QueryHelper.createQuery(QueryHelper.queryCompiler(queryReader, finder), finder);
    }

    public static Query createQuery(InputStream queryInput, Finder finder) throws IOException {
        return QueryHelper.createQuery(QueryHelper.queryCompiler(queryInput, finder), finder);
    }

    public static Query createQuery(InputStream inputStream, Charset charset, Finder finder) throws IOException {
        return QueryHelper.createQuery(QueryHelper.queryCompiler(inputStream, charset, finder), finder);
    }

    public static Query createQuery(QueryModel queryModel, CompilerArguments compilerArguments, Finder finder) throws IOException {
        return QueryHelper.createQuery(QueryHelper.queryCompiler(queryModel, compilerArguments, finder), finder);
    }

    public static Query createQuery(QIL qil, Finder finder) {
        return new QueryImpl(qil, finder);
    }
}

