/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.hasor.dataql.CustomizeScope;
import net.hasor.dataql.Finder;
import net.hasor.dataql.Query;
import net.hasor.dataql.compiler.qil.QIL;
import net.hasor.dataql.domain.DataModel;
import net.hasor.dataql.runtime.HintsSet;
import net.hasor.dataql.runtime.InsetProcessContext;
import net.hasor.dataql.runtime.InstSequence;
import net.hasor.dataql.runtime.QueryResultImpl;
import net.hasor.dataql.runtime.QueryRuntimeException;
import net.hasor.dataql.runtime.inset.OpcodesPool;
import net.hasor.dataql.runtime.mem.DataHeap;
import net.hasor.dataql.runtime.mem.DataStack;
import net.hasor.dataql.runtime.mem.EnvStack;
import net.hasor.dataql.runtime.mem.ExitType;

class QueryImpl
extends HintsSet
implements Query {
    private final QIL qil;
    private final Finder finder;
    private final Map<String, Object> shareVarMap;

    QueryImpl(QIL qil, Finder finder) {
        this.qil = qil;
        this.finder = finder;
        this.shareVarMap = new HashMap<String, Object>();
    }

    @Override
    public Query clone() {
        QueryImpl query = new QueryImpl(this.qil, this.finder);
        query.shareVarMap.putAll(this.shareVarMap);
        return query;
    }

    @Override
    public void addShareVar(String key, Object value) {
        this.shareVarMap.put(key, value);
    }

    @Override
    public QueryResultImpl execute(CustomizeScope customize) throws QueryRuntimeException {
        InstSequence instSequence = new InstSequence(0, this.qil);
        if (customize == null) {
            customize = symbol -> Collections.emptyMap();
        }
        InsetProcessContext processContext = new InsetProcessContext(customize, this.finder);
        processContext.currentHints().setHints(this);
        DataStack dataStack = new DataStack();
        DataHeap dataHeap = new DataHeap();
        EnvStack envStack = new EnvStack();
        this.qil.getCompilerVar().forEach((? super K varName, ? super V varLocalIdx) -> {
            Object varVal = this.shareVarMap.get(varName);
            dataHeap.saveData((int)varLocalIdx, varVal);
        });
        OpcodesPool opcodesPool = OpcodesPool.defaultOpcodesPool();
        while (instSequence.hasNext()) {
            opcodesPool.doWork(instSequence, dataHeap, dataStack, envStack, processContext);
            instSequence.doNext(1);
        }
        ExitType exitType = dataStack.getExitType() == null ? ExitType.Return : dataStack.getExitType();
        int resultCode = dataStack.getResultCode();
        DataModel result = dataStack.getResult();
        long executionTime = processContext.executionTime();
        return new QueryResultImpl(exitType, resultCode, result, executionTime);
    }
}

