/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime.inset;

import net.hasor.dataql.domain.DataModel;
import net.hasor.dataql.domain.DomainHelper;
import net.hasor.dataql.domain.TypeOfEnum;
import net.hasor.dataql.domain.ValueModel;
import net.hasor.dataql.runtime.InsetProcess;
import net.hasor.dataql.runtime.InsetProcessContext;
import net.hasor.dataql.runtime.InstSequence;
import net.hasor.dataql.runtime.QueryRuntimeException;
import net.hasor.dataql.runtime.mem.DataHeap;
import net.hasor.dataql.runtime.mem.DataStack;
import net.hasor.dataql.runtime.mem.EnvStack;

class TYPEOF
implements InsetProcess {
    TYPEOF() {
    }

    @Override
    public int getOpcode() {
        return 43;
    }

    @Override
    public void doWork(InstSequence sequence, DataHeap dataHeap, DataStack dataStack, EnvStack envStack, InsetProcessContext context) {
        DataModel dataModel = DomainHelper.convertTo(dataStack.pop());
        if (dataModel.isObject()) {
            dataStack.push(TypeOfEnum.Object.typeCode());
            return;
        }
        if (dataModel.isList()) {
            dataStack.push(TypeOfEnum.List.typeCode());
            return;
        }
        if (dataModel.isUdf()) {
            dataStack.push(TypeOfEnum.Udf.typeCode());
            return;
        }
        if (dataModel.isValue()) {
            ValueModel val = (ValueModel)dataModel;
            if (val.isNull()) {
                dataStack.push(TypeOfEnum.Null.typeCode());
                return;
            }
            if (val.isNumber()) {
                dataStack.push(TypeOfEnum.Number.typeCode());
                return;
            }
            if (val.isString()) {
                dataStack.push(TypeOfEnum.String.typeCode());
                return;
            }
            if (val.isBoolean()) {
                dataStack.push(TypeOfEnum.Boolean.typeCode());
                return;
            }
        }
        throw new QueryRuntimeException(sequence.programLocation(), "DataModel type is unknown.");
    }
}

