/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime.mem;

import java.util.Map;
import net.hasor.dataql.DataQueryException;
import net.hasor.dataql.Finder;
import net.hasor.dataql.Hints;
import net.hasor.dataql.Udf;
import net.hasor.dataql.UdfSource;
import net.hasor.dataql.domain.DataModel;
import net.hasor.dataql.domain.DomainHelper;
import net.hasor.dataql.parser.location.RuntimeLocation;
import net.hasor.dataql.runtime.QueryRuntimeException;
import net.hasor.utils.ExceptionUtils;

public class RefCall {
    private final RuntimeLocation location;
    private final boolean autoUnwrap;
    private final Udf refCall;

    public RefCall(RuntimeLocation location, boolean autoUnwrap, Udf refCall) {
        this.location = location;
        this.autoUnwrap = autoUnwrap;
        this.refCall = refCall;
    }

    public Object invokeMethod(Object[] paramArrays, Hints optionSet, Finder finder) throws DataQueryException {
        try {
            Map<String, Udf> result;
            Object[] objects = (Object[])paramArrays.clone();
            if (this.autoUnwrap) {
                for (int i = 0; i < objects.length; ++i) {
                    if (!(objects[i] instanceof DataModel)) continue;
                    objects[i] = ((DataModel)objects[i]).unwrap();
                }
            }
            if ((result = this.refCall.call(optionSet, objects)) instanceof UdfSource) {
                result = ((UdfSource)((Object)result)).getUdfResource(finder).get();
            }
            return DomainHelper.convertTo(result);
        }
        catch (Throwable e) {
            if (e instanceof DataQueryException) {
                throw (DataQueryException)e;
            }
            throw ExceptionUtils.toRuntimeException((Throwable)e, throwable -> {
                String message = e.getClass().getName() + ": " + throwable.getLocalizedMessage();
                return new QueryRuntimeException(this.location, message, (Throwable)throwable);
            });
        }
    }
}

