/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime.mem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.hasor.dataql.FragmentProcess;
import net.hasor.dataql.Hints;
import net.hasor.dataql.Udf;
import net.hasor.dataql.parser.location.RuntimeLocation;
import net.hasor.dataql.runtime.QueryRuntimeException;

public class RefFragmentCall
implements Udf {
    private final RuntimeLocation location;
    private final boolean isBach;
    private final FragmentProcess fragmentProcess;

    public RefFragmentCall(RuntimeLocation location, boolean isBach, FragmentProcess fragmentProcess) {
        this.location = location;
        this.isBach = isBach;
        this.fragmentProcess = fragmentProcess;
    }

    @Override
    public Object call(Hints readOnly, Object ... params) throws Throwable {
        String fragmentString = params[1].toString();
        Map fragmentParams = (Map)params[0];
        if (this.isBach) {
            ArrayList<Map<String, Object>> fragmentParamsArray = new ArrayList<Map<String, Object>>();
            TreeMap<String, Integer> argsLengthMap = new TreeMap<String, Integer>();
            int lastSize = -1;
            boolean argsLengthError = false;
            for (String key2 : fragmentParams.keySet()) {
                Object dataModel = fragmentParams.get(key2);
                if (!(dataModel instanceof List)) {
                    throw new QueryRuntimeException(this.location, "The batch fragment args must be an array.");
                }
                List listData = (List)dataModel;
                int tmpSize = listData.size();
                argsLengthMap.put(key2, tmpSize);
                if (lastSize < 0) {
                    lastSize = tmpSize;
                } else if (tmpSize != lastSize) {
                    argsLengthError = true;
                }
                if (argsLengthError) continue;
                for (int i = 0; i < listData.size(); ++i) {
                    if (i >= fragmentParamsArray.size()) {
                        fragmentParamsArray.add(new HashMap());
                    }
                    Map objectMap = (Map)fragmentParamsArray.get(i);
                    objectMap.put(key2, listData.get(i));
                }
            }
            if (argsLengthError) {
                StringBuilder strBuild = new StringBuilder();
                argsLengthMap.forEach((key, integer) -> strBuild.append(key + "=" + integer + ","));
                if (strBuild.length() > 0) {
                    strBuild.deleteCharAt(strBuild.length() - 1);
                }
                throw new QueryRuntimeException(this.location, "batch fragment,All args must have the same length -> [" + strBuild.toString() + "]");
            }
            return this.fragmentProcess.batchRunFragment(readOnly, fragmentParamsArray, fragmentString);
        }
        return this.fragmentProcess.runFragment(readOnly, fragmentParams, fragmentString);
    }
}

