/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime.mem;

import net.hasor.dataql.Hints;
import net.hasor.dataql.Udf;
import net.hasor.dataql.domain.DataModel;
import net.hasor.dataql.domain.DomainHelper;
import net.hasor.dataql.runtime.InsetProcessContext;
import net.hasor.dataql.runtime.InstSequence;
import net.hasor.dataql.runtime.inset.OpcodesPool;
import net.hasor.dataql.runtime.mem.DataHeap;
import net.hasor.dataql.runtime.mem.DataStack;
import net.hasor.dataql.runtime.mem.EnvStack;
import net.hasor.dataql.runtime.mem.ExitType;
import net.hasor.dataql.runtime.mem.RefLambdaCallException;
import net.hasor.dataql.runtime.mem.RefLambdaCallStruts;

public class RefLambdaCall
implements Udf {
    private final InstSequence instSequence;
    private final DataHeap dataHeap;
    private final EnvStack envStack;
    private final InsetProcessContext context;

    public RefLambdaCall(InstSequence instSequence, DataHeap dataHeap, EnvStack envStack, InsetProcessContext context) {
        this.instSequence = instSequence;
        this.dataHeap = dataHeap;
        this.envStack = envStack;
        this.context = context;
    }

    @Override
    public Object call(Hints readOnly, final Object ... params) throws Throwable {
        DataStack cloneStack = new DataStack(){
            {
                this.push(new RefLambdaCallStruts(params));
            }
        };
        InstSequence instSequence = this.instSequence.clone();
        OpcodesPool opcodesPool = OpcodesPool.defaultOpcodesPool();
        DataHeap dataHeap = new DataHeap(this.dataHeap);
        while (instSequence.hasNext()) {
            opcodesPool.doWork(instSequence, dataHeap, cloneStack, this.envStack, this.context);
            instSequence.doNext(1);
        }
        DataModel result = cloneStack.getResult();
        if (cloneStack.getExitType() != ExitType.Throw) {
            return result != null ? result.unwrap() : DomainHelper.nullDomain();
        }
        throw new RefLambdaCallException(instSequence.programLocation(), cloneStack.getResultCode(), cloneStack.getResult());
    }
}

