/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime.operator.ops;

import net.hasor.dataql.Hints;
import net.hasor.dataql.parser.location.RuntimeLocation;
import net.hasor.dataql.runtime.QueryRuntimeException;
import net.hasor.dataql.runtime.operator.OperatorUtils;
import net.hasor.dataql.runtime.operator.ops.AbstractDOP;

public class BinaryDOP
extends AbstractDOP {
    private static final Integer BOOL_FALSE = 0;
    private static final Integer BOOL_TRUE = 1;

    @Override
    public Object doDyadicProcess(RuntimeLocation location, String operator, Object fstObject, Object secObject, Hints option) throws QueryRuntimeException {
        if (OperatorUtils.isBoolean(fstObject) && OperatorUtils.isBoolean(secObject)) {
            fstObject = Boolean.TRUE.equals(fstObject) ? BOOL_TRUE : BOOL_FALSE;
            Object object = secObject = Boolean.TRUE.equals(secObject) ? BOOL_TRUE : BOOL_FALSE;
        }
        if (OperatorUtils.isBoolean(fstObject) && OperatorUtils.isNumber(secObject)) {
            fstObject = Boolean.TRUE.equals(fstObject) ? BOOL_TRUE : BOOL_FALSE;
            Object object = secObject = OperatorUtils.eq((Number)secObject, 0) ? BOOL_FALSE : BOOL_TRUE;
        }
        if (OperatorUtils.isNumber(fstObject) && OperatorUtils.isBoolean(secObject)) {
            fstObject = OperatorUtils.eq((Number)fstObject, 0) ? BOOL_FALSE : BOOL_TRUE;
            Object object = secObject = Boolean.TRUE.equals(secObject) ? BOOL_TRUE : BOOL_FALSE;
        }
        if ("&".equals(operator)) {
            return OperatorUtils.and((Number)fstObject, (Number)secObject);
        }
        if ("|".equals(operator)) {
            return OperatorUtils.or((Number)fstObject, (Number)secObject);
        }
        if ("^".equals(operator)) {
            return OperatorUtils.xor((Number)fstObject, (Number)secObject);
        }
        if ("<<".equals(operator)) {
            return OperatorUtils.shiftLeft((Number)fstObject, (Number)secObject);
        }
        if (">>".equals(operator)) {
            return OperatorUtils.shiftRight((Number)fstObject, (Number)secObject);
        }
        if (">>>".equals(operator)) {
            return OperatorUtils.shiftRightWithUnsigned((Number)fstObject, (Number)secObject);
        }
        throw BinaryDOP.throwError(location, operator, fstObject, secObject, "this operator nonsupport.");
    }
}

