/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime.operator.ops;

import java.math.BigDecimal;
import net.hasor.dataql.Hints;
import net.hasor.dataql.parser.location.RuntimeLocation;
import net.hasor.dataql.runtime.QueryRuntimeException;
import net.hasor.dataql.runtime.operator.OperatorUtils;
import net.hasor.dataql.runtime.operator.ops.AbstractDOP;
import net.hasor.dataql.runtime.operator.ops.RoundingEnum;

public class NumberDOP
extends AbstractDOP {
    @Override
    public Object doDyadicProcess(RuntimeLocation location, String operator, Object fstObject, Object secObject, Hints option) throws QueryRuntimeException {
        if (!(fstObject instanceof Number) || !(secObject instanceof Number)) {
            throw NumberDOP.throwError(location, operator, fstObject, secObject, "requirements must be numerical.");
        }
        RoundingEnum roundingMode = RoundingEnum.find((String)option.getHint("NUMBER_ROUNDING"));
        int maxDecimal = option.getOrMap("MAX_DECIMAL_DIGITS", val -> {
            if (val == null) {
                return 20;
            }
            if (val instanceof Number) {
                return ((Number)val).intValue();
            }
            return Integer.parseInt(val.toString());
        });
        String decimalWidth = (String)option.getHint("MIN_DECIMAL_WIDTH");
        String integerWidth = (String)option.getHint("MIN_INTEGER_WIDTH");
        fstObject = OperatorUtils.fixNumberWidth((Number)fstObject, decimalWidth, integerWidth);
        secObject = OperatorUtils.fixNumberWidth((Number)secObject, decimalWidth, integerWidth);
        Number result = null;
        switch (operator.charAt(0)) {
            case '+': {
                result = OperatorUtils.add((Number)fstObject, (Number)secObject);
                break;
            }
            case '-': {
                result = OperatorUtils.subtract((Number)fstObject, (Number)secObject);
                break;
            }
            case '*': {
                result = OperatorUtils.multiply((Number)fstObject, (Number)secObject);
                break;
            }
            case '/': {
                result = OperatorUtils.divide((Number)fstObject, (Number)secObject, maxDecimal, roundingMode);
                break;
            }
            case '\\': {
                result = OperatorUtils.aliquot((Number)fstObject, (Number)secObject);
                break;
            }
            case '%': {
                result = OperatorUtils.mod((Number)fstObject, (Number)secObject);
                break;
            }
            default: {
                throw NumberDOP.throwError(location, operator, fstObject, secObject, "this operator nonsupport.");
            }
        }
        if (result == null) {
            throw NumberDOP.throwError(location, operator, fstObject, secObject, "evaluation result is empty.");
        }
        if (OperatorUtils.isFloatNumber(result) && maxDecimal < 7) {
            float number = ((Float)result).floatValue();
            if (number == Float.POSITIVE_INFINITY || Float.isNaN(number) || number == Float.NEGATIVE_INFINITY) {
                return result.toString();
            }
            BigDecimal resultDecimal = new BigDecimal(result.toString());
            resultDecimal = resultDecimal.setScale(maxDecimal, roundingMode.getModeNum());
            return Float.valueOf(resultDecimal.floatValue());
        }
        if (OperatorUtils.isDoubleNumber(result) && maxDecimal < 16) {
            double number = (Double)result;
            if (number == Double.POSITIVE_INFINITY || Double.isNaN(number) || number == Double.NEGATIVE_INFINITY) {
                return result.toString();
            }
            BigDecimal resultDecimal = new BigDecimal(result.toString());
            resultDecimal = resultDecimal.setScale(maxDecimal, roundingMode.getModeNum());
            return resultDecimal.doubleValue();
        }
        if (result instanceof BigDecimal) {
            return ((BigDecimal)result).setScale(maxDecimal, roundingMode.getModeNum()).stripTrailingZeros();
        }
        return result;
    }
}

