/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.config;

import com.alibaba.fastjson.JSONObject;
import java.util.LinkedHashMap;
import java.util.Map;
import net.hasor.dataql.QueryResult;
import net.hasor.dataql.domain.DataModel;
import net.hasor.dataql.runtime.ThrowRuntimeException;
import net.hasor.dataway.config.Result;

public class DatawayUtils {
    private static final ThreadLocal<Long> localRequestTime = ThreadLocal.withInitial(System::currentTimeMillis);

    public static String evalCodeValueForSQL(String strCodeValue, Map<String, Object> strRequestBody) {
        StringBuilder paramKeyBuilder = new StringBuilder("");
        StringBuilder callKeyBuilder = new StringBuilder("");
        for (String key : strRequestBody.keySet()) {
            paramKeyBuilder.append("`" + key + "`,");
            callKeyBuilder.append("${" + key + "},");
        }
        if (paramKeyBuilder.length() > 0) {
            paramKeyBuilder.deleteCharAt(paramKeyBuilder.length() - 1);
            callKeyBuilder.deleteCharAt(callKeyBuilder.length() - 1);
        }
        strCodeValue = "var tempCall = @@sql(" + paramKeyBuilder.toString() + ")<%" + strCodeValue + "%>;\n";
        strCodeValue = strCodeValue + "return tempCall(" + callKeyBuilder.toString() + ");";
        return strCodeValue;
    }

    public static long resetLocalTime() {
        long currentTimeMillis = System.currentTimeMillis();
        localRequestTime.remove();
        localRequestTime.set(currentTimeMillis);
        return currentTimeMillis;
    }

    public static long currentLostTime() {
        return System.currentTimeMillis() - localRequestTime.get();
    }

    public static boolean isResultStructure(Map<String, Object> optionMap) {
        if (optionMap == null) {
            return true;
        }
        return (Boolean)optionMap.getOrDefault("resultStructure", true);
    }

    public static Result<Object> queryResultToResultWithSpecialValue(Map<String, Object> optionMap, final QueryResult queryResult, Object specialValue) {
        final Object resultValue = specialValue instanceof DataModel ? ((DataModel)specialValue).unwrap() : specialValue;
        if (!DatawayUtils.isResultStructure(optionMap)) {
            return Result.of(resultValue);
        }
        LinkedHashMap<String, Object> resultData = new LinkedHashMap<String, Object>(){
            {
                this.put("success", true);
                this.put("message", "OK");
                this.put("code", queryResult.getCode());
                this.put("lifeCycleTime", DatawayUtils.currentLostTime());
                this.put("executionTime", queryResult.executionTime());
                this.put("value", resultValue);
            }
        };
        return Result.of(DatawayUtils.doResponseFormat(optionMap, (Map<String, Object>)resultData));
    }

    public static Result<Object> exceptionToResult(Throwable e) {
        if (e instanceof ThrowRuntimeException) {
            return DatawayUtils.exceptionToResultWithSpecialValue(null, e, ((ThrowRuntimeException)e).getResult().unwrap());
        }
        return DatawayUtils.exceptionToResultWithSpecialValue(null, e, e.getMessage());
    }

    public static Result<Object> exceptionToResultWithSpecialValue(Map<String, Object> optionMap, final Throwable e, final Object specialValue) {
        if (!DatawayUtils.isResultStructure(optionMap) && specialValue != null) {
            return Result.of(specialValue);
        }
        LinkedHashMap<String, Object> resultData = null;
        resultData = e instanceof ThrowRuntimeException ? new LinkedHashMap<String, Object>(){
            {
                this.put("success", false);
                this.put("message", e.getMessage());
                this.put("code", ((ThrowRuntimeException)e).getThrowCode());
                this.put("lifeCycleTime", DatawayUtils.currentLostTime());
                this.put("executionTime", ((ThrowRuntimeException)e).getExecutionTime());
                this.put("value", specialValue);
            }
        } : new LinkedHashMap<String, Object>(){
            {
                this.put("success", false);
                this.put("message", e.getMessage());
                this.put("code", 500);
                this.put("lifeCycleTime", DatawayUtils.currentLostTime());
                this.put("executionTime", -1);
                this.put("value", specialValue);
            }
        };
        return Result.of(DatawayUtils.doResponseFormat(optionMap, (Map<String, Object>)resultData));
    }

    private static Object doResponseFormat(Map<String, Object> optionMap, Map<String, Object> resultData) {
        if (optionMap == null || !optionMap.containsKey("responseFormat")) {
            return resultData;
        }
        Object responseFormat = optionMap.get("responseFormat");
        LinkedHashMap<String, Object> finalResult = new LinkedHashMap<String, Object>();
        LinkedHashMap jsonObject = (LinkedHashMap)JSONObject.parseObject((String)responseFormat.toString(), LinkedHashMap.class);
        block16: for (Object key : jsonObject.keySet()) {
            Object value = jsonObject.get(key);
            if (value == null) {
                finalResult.put(key.toString(), null);
                continue;
            }
            switch (value.toString()) {
                case "@resultStatus": {
                    finalResult.put(key.toString(), resultData.get("success"));
                    continue block16;
                }
                case "@resultMessage": {
                    finalResult.put(key.toString(), resultData.get("message"));
                    continue block16;
                }
                case "@resultCode": {
                    finalResult.put(key.toString(), resultData.get("code"));
                    continue block16;
                }
                case "@timeLifeCycle": {
                    finalResult.put(key.toString(), resultData.get("lifeCycleTime"));
                    continue block16;
                }
                case "@timeExecution": {
                    finalResult.put(key.toString(), resultData.get("executionTime"));
                    continue block16;
                }
                case "@resultData": {
                    finalResult.put(key.toString(), resultData.get("value"));
                    continue block16;
                }
            }
            finalResult.put(key.toString(), value);
        }
        return finalResult;
    }
}

