/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.dataql.DataQL;
import net.hasor.dataql.QueryResult;
import net.hasor.dataql.domain.ObjectModel;
import net.hasor.dataway.config.CorsUtils;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.daos.ReleaseDetailQuery;
import net.hasor.dataway.service.ApiCallService;
import net.hasor.dataway.spi.ApiInfo;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerChain;
import net.hasor.web.InvokerConfig;
import net.hasor.web.InvokerFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InterfaceApiFilter
implements InvokerFilter {
    protected static Logger logger = LoggerFactory.getLogger(InterfaceApiFilter.class);
    @Inject
    @Named(value="net.hasor.dataway.config.DatawayModule")
    private DataQL dataQL;
    @Inject
    private ApiCallService callService;
    private String apiBaseUri;

    public InterfaceApiFilter(String apiBaseUri) {
        this.apiBaseUri = apiBaseUri;
    }

    public void init(InvokerConfig config) {
        config.getAppContext().justInject((Object)this);
        Objects.requireNonNull(this.dataQL, "dataQL init failed");
    }

    public Object doInvoke(Invoker invoker, InvokerChain chain) throws Throwable {
        Object jsonParam;
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        HttpServletResponse httpResponse = invoker.getHttpResponse();
        final String requestURI = invoker.getRequestPath();
        final String httpMethod = httpRequest.getMethod().toUpperCase().trim();
        if (!requestURI.startsWith(this.apiBaseUri)) {
            return chain.doNext(invoker);
        }
        DatawayUtils.resetLocalTime();
        String mimeType = invoker.getMimeType("json");
        httpRequest.setCharacterEncoding("UTF-8");
        httpResponse.setCharacterEncoding("UTF-8");
        CorsUtils.setup(invoker);
        ApiInfo apiInfo = new ApiInfo();
        apiInfo.setPerform(false);
        String script = null;
        try {
            QueryResult queryResult = new ReleaseDetailQuery(this.dataQL).execute(new HashMap<String, String>(){
                {
                    this.put("apiMethod", httpMethod);
                    this.put("apiPath", URLDecoder.decode(requestURI, "UTF-8"));
                }
            });
            ObjectModel dataModel = (ObjectModel)queryResult.getData();
            apiInfo.setApiID(dataModel.getValue("apiID").asString());
            apiInfo.setReleaseID(dataModel.getValue("releaseID").asString());
            apiInfo.setMethod(httpMethod);
            apiInfo.setApiPath(requestURI);
            apiInfo.setOptionMap(dataModel.getObject("optionData").unwrap());
            script = dataModel.getValue("script").asString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Object result = DatawayUtils.exceptionToResult(e).getResult();
            return this.responseData(mimeType, httpResponse, result);
        }
        if ("GET".equalsIgnoreCase(httpMethod)) {
            jsonParam = new HashMap();
            Enumeration parameterNames = httpRequest.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String paramName = (String)parameterNames.nextElement();
                jsonParam.put(paramName + "Arrays", httpRequest.getParameterValues(paramName));
                jsonParam.put(paramName, httpRequest.getParameter(paramName));
            }
        } else {
            String jsonBody = invoker.getJsonBodyString();
            jsonParam = StringUtils.isNotBlank((String)jsonBody) ? JSON.parseObject((String)jsonBody) : new HashMap();
        }
        apiInfo.setParameterMap((Map<String, Object>)jsonParam);
        String finalScript = script;
        Object objectMap = this.callService.doCallWithoutError(apiInfo, param -> finalScript);
        return this.responseData(mimeType, httpResponse, objectMap);
    }

    private Object responseData(String mimeType, HttpServletResponse httpResponse, Object objectMap) throws IOException {
        if (!httpResponse.isCommitted()) {
            String body = JSON.toJSONString((Object)objectMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            byte[] bodyByte = body.getBytes();
            httpResponse.setContentType(mimeType);
            httpResponse.setContentLength(bodyByte.length);
            ServletOutputStream output = httpResponse.getOutputStream();
            output.write(bodyByte);
            output.flush();
            output.close();
        }
        return objectMap;
    }
}

