/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.config;

import com.alibaba.fastjson.JSON;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.dataway.config.DatawayModule;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.utils.ResourcesUtils;
import net.hasor.utils.StringUtils;
import net.hasor.utils.io.FilenameUtils;
import net.hasor.utils.io.IOUtils;
import net.hasor.utils.io.output.ByteArrayOutputStream;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerChain;
import net.hasor.web.InvokerFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InterfaceUiFilter
implements InvokerFilter {
    protected static Logger logger = LoggerFactory.getLogger(InterfaceUiFilter.class);
    private static final String resourceBaseUri = "/META-INF/hasor-framework/dataway-ui/";
    private String resourceIndexUri = null;
    private String apiBaseUri;
    private String uiBaseUri;
    private String uiAdminBaseUri;
    private Map<String, Integer> resourceSize;

    public InterfaceUiFilter(String apiBaseUri, String uiBaseUri) {
        this.apiBaseUri = apiBaseUri;
        this.uiBaseUri = uiBaseUri;
        this.uiAdminBaseUri = DatawayModule.fixUrl(uiBaseUri + "/api/");
        this.resourceIndexUri = DatawayModule.fixUrl(uiBaseUri + "/index.html");
        this.resourceSize = new ConcurrentHashMap<String, Integer>();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doInvoke(Invoker invoker, InvokerChain chain) throws Throwable {
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        HttpServletResponse httpResponse = invoker.getHttpResponse();
        httpRequest.setCharacterEncoding("UTF-8");
        httpResponse.setCharacterEncoding("UTF-8");
        String requestURI = invoker.getRequestPath();
        if (requestURI.startsWith(this.uiAdminBaseUri)) {
            try {
                DatawayUtils.resetLocalTime();
                return chain.doNext(invoker);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                Object objectMap = DatawayUtils.exceptionToResult(e).getResult();
                PrintWriter writer = httpResponse.getWriter();
                writer.write(JSON.toJSONString((Object)objectMap));
                writer.flush();
                return objectMap;
            }
        }
        if (this.uiBaseUri.equalsIgnoreCase(requestURI)) {
            requestURI = this.resourceIndexUri;
        }
        if (requestURI.equalsIgnoreCase(this.resourceIndexUri)) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (InputStream inputStream = ResourcesUtils.getResourceAsStream((String)DatawayModule.fixUrl("/META-INF/hasor-framework/dataway-ui//index.html"));){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            String contextPath = httpRequest.getContextPath();
            if (StringUtils.isBlank((String)contextPath)) {
                contextPath = "/";
            }
            if (contextPath.endsWith("/")) {
                contextPath = contextPath.substring(0, contextPath.length() - 1);
            }
            String htmlBody = new String(outputStream.toByteArray());
            htmlBody = htmlBody.replace("{CONTEXT_PATH}", contextPath);
            htmlBody = htmlBody.replace("{API_BASE_URL}", DatawayModule.fixUrl(this.apiBaseUri));
            htmlBody = htmlBody.replace("{ADMIN_BASE_URL}", DatawayModule.fixUrl(this.uiBaseUri));
            htmlBody = htmlBody.replace("{ALL_MAC}", InterfaceUiFilter.allLocalMac());
            httpResponse.setContentType(invoker.getMimeType("html"));
            httpResponse.setContentLength(htmlBody.length());
            PrintWriter writer = httpResponse.getWriter();
            writer.write(htmlBody);
            writer.flush();
            return null;
        }
        if (!requestURI.startsWith(this.uiBaseUri)) return chain.doNext(invoker);
        String extension = FilenameUtils.getExtension((String)requestURI);
        String mimeType = invoker.getMimeType(extension);
        if (StringUtils.isNotBlank((String)mimeType)) {
            httpResponse.setContentType(mimeType);
        }
        String resourceName = DatawayModule.fixUrl(resourceBaseUri + requestURI.substring(this.uiBaseUri.length()));
        try (ServletOutputStream outputStream = httpResponse.getOutputStream();){
            ServletOutputStream output = null;
            Integer size = this.resourceSize.get(resourceName);
            if (size == null) {
                output = new ByteArrayOutputStream();
            } else {
                output = outputStream;
                httpResponse.setContentLength(size.intValue());
            }
            try {
                Throwable throwable;
                InputStream inputStream;
                block57: {
                    Object var15_29;
                    block58: {
                        inputStream = ResourcesUtils.getResourceAsStream((String)resourceName);
                        throwable = null;
                        if (inputStream != null) break block57;
                        httpResponse.sendError(404, "not found " + requestURI);
                        var15_29 = null;
                        if (inputStream == null) return var15_29;
                        if (throwable == null) break block58;
                        try {
                            inputStream.close();
                            return var15_29;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return var15_29;
                        }
                    }
                    inputStream.close();
                    return var15_29;
                }
                try {
                    IOUtils.copy((InputStream)inputStream, (OutputStream)output);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("load " + resourceName + " failed -> " + e.getMessage(), (Throwable)e);
            }
            if (size == null) {
                byte[] byteArray = ((ByteArrayOutputStream)output).toByteArray();
                size = byteArray.length;
                this.resourceSize.put(resourceName, size);
                outputStream.write(byteArray);
            }
            outputStream.flush();
            return null;
        }
    }

    private static String allLocalMac() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        HashSet<String> macPool = new HashSet<String>();
        while (interfaces.hasMoreElements()) {
            NetworkInterface nextElement = interfaces.nextElement();
            byte[] hardwareAddress = nextElement.getHardwareAddress();
            if (hardwareAddress == null) continue;
            StringBuilder strBuilder = new StringBuilder();
            for (int i = 0; i < hardwareAddress.length; ++i) {
                String str = Integer.toHexString(hardwareAddress[i] & 0xFF);
                strBuilder.append(str.length() == 1 ? "0" + str : str);
            }
            macPool.add(strBuilder.toString());
        }
        return StringUtils.join((Object[])macPool.toArray(), (String)",").toUpperCase();
    }
}

