/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.service;

import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.hasor.core.spi.SpiTrigger;
import net.hasor.dataql.DataQL;
import net.hasor.dataql.Finder;
import net.hasor.dataql.QueryResult;
import net.hasor.dataql.compiler.qil.QIL;
import net.hasor.dataql.domain.DataModel;
import net.hasor.dataql.domain.DomainHelper;
import net.hasor.dataql.runtime.ThrowRuntimeException;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.config.LoggerUtils;
import net.hasor.dataway.service.QueryResultInfo;
import net.hasor.dataway.service.QueryScriptBuild;
import net.hasor.dataway.spi.ApiInfo;
import net.hasor.dataway.spi.CompilerSpiListener;
import net.hasor.dataway.spi.PreExecuteChainSpi;
import net.hasor.dataway.spi.ResultProcessChainSpi;
import net.hasor.utils.future.BasicFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ApiCallService {
    protected static Logger logger = LoggerFactory.getLogger(ApiCallService.class);
    @Inject
    private SpiTrigger spiTrigger;
    @Inject
    private DataQL executeDataQL;

    public Object doCallWithoutError(ApiInfo apiInfo, QueryScriptBuild scriptBuild) throws Throwable {
        return this._doCall(apiInfo, scriptBuild, false);
    }

    public Object doCall(ApiInfo apiInfo, QueryScriptBuild scriptBuild) throws Throwable {
        return this._doCall(apiInfo, scriptBuild, true);
    }

    private Object _doCall(ApiInfo apiInfo, QueryScriptBuild scriptBuild, boolean needThrow) throws Throwable {
        LoggerUtils loggerUtils = LoggerUtils.create();
        loggerUtils.addLog("apiMethod", apiInfo.getMethod());
        loggerUtils.addLog("apiPath", apiInfo.getApiPath());
        if (apiInfo.getParameterMap() != null) {
            loggerUtils.addLog("paramRootKeys", apiInfo.getParameterMap().keySet());
        } else {
            loggerUtils.addLog("paramRootKeys", "empty.");
        }
        BasicFuture newResult = new BasicFuture();
        QueryResult execute = null;
        try {
            this.spiTrigger.chainSpi(PreExecuteChainSpi.class, (listener, lastResult) -> {
                if (!newResult.isDone()) {
                    listener.preExecute(apiInfo, (BasicFuture<Object>)newResult);
                }
                return lastResult;
            });
            if (newResult.isDone()) {
                Object data = newResult.get();
                execute = data instanceof QueryResult ? (QueryResult)data : QueryResultInfo.of(0, DomainHelper.convertTo((Object)data), DatawayUtils.currentLostTime());
            } else {
                Finder finder;
                Set<String> varNames;
                String scriptBody = scriptBuild.buildScript(apiInfo.getParameterMap());
                QIL compiler = (QIL)this.spiTrigger.notifySpi(CompilerSpiListener.class, (arg_0, arg_1) -> ApiCallService.lambda$_doCall$1(apiInfo, scriptBody, varNames = this.executeDataQL.getShareVarMap().keySet(), finder = this.executeDataQL.getFinder(), arg_0, arg_1), null);
                if (compiler == null) {
                    compiler = CompilerSpiListener.DEFAULT.compiler(apiInfo, scriptBody, varNames, finder);
                }
                loggerUtils.addLog("compilerTime", DatawayUtils.currentLostTime());
                execute = this.executeDataQL.createQuery(compiler).execute(apiInfo.getParameterMap());
            }
            loggerUtils.addLog("executionTime", execute.executionTime());
            loggerUtils.addLog("lifeCycleTime", DatawayUtils.currentLostTime());
            loggerUtils.addLog("code", execute.getCode());
            logger.info("requestSuccess - " + loggerUtils.toJson());
        }
        catch (Throwable e) {
            logger.error("requestFailed - " + loggerUtils.logException(e).toJson());
            return this.doError(needThrow, newResult.isDone(), e, apiInfo, loggerUtils);
        }
        try {
            Object resultData = execute.getData();
            resultData = this.spiTrigger.chainSpi(ResultProcessChainSpi.class, (listener, lastResult) -> {
                if (lastResult instanceof DataModel) {
                    lastResult = ((DataModel)lastResult).unwrap();
                }
                return listener.callAfter(newResult.isDone(), apiInfo, lastResult);
            }, resultData);
            return DatawayUtils.queryResultToResultWithSpecialValue(apiInfo.getOptionMap(), execute, resultData).getResult();
        }
        catch (Throwable e) {
            logger.error("requestFailed - " + loggerUtils.logException(e).toJson());
            return this.doError(needThrow, newResult.isDone(), e, apiInfo, loggerUtils);
        }
    }

    private Object doError(boolean needThrow, boolean isFormPre, Throwable e, ApiInfo apiInfo, LoggerUtils loggerUtils) throws Throwable {
        Object value = null;
        if (e instanceof ExecutionException) {
            e = e.getCause();
        }
        value = e instanceof ThrowRuntimeException ? ((ThrowRuntimeException)e).getResult().unwrap() : e.getMessage();
        logger.error("requestFailed - " + loggerUtils.logException(e).toJson());
        try {
            Throwable finalE = e;
            value = this.spiTrigger.chainSpi(ResultProcessChainSpi.class, (listener, lastResult) -> listener.callError(isFormPre, apiInfo, finalE), value);
        }
        catch (Throwable ee) {
            logger.error(ee.getMessage(), ee);
            e = ee;
        }
        if (needThrow) {
            throw e;
        }
        return DatawayUtils.exceptionToResultWithSpecialValue(apiInfo.getOptionMap(), e, value).getResult();
    }

    private static /* synthetic */ QIL lambda$_doCall$1(ApiInfo apiInfo, String scriptBody, Set varNames, Finder finder, CompilerSpiListener listener, QIL lastResult) throws Throwable {
        return listener.compiler(apiInfo, scriptBody, varNames, finder);
    }
}

