/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.web;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.hasor.dataql.QueryResult;
import net.hasor.dataql.domain.ObjectModel;
import net.hasor.dataql.runtime.HintsSet;
import net.hasor.dataway.config.MappingToUrl;
import net.hasor.dataway.config.Result;
import net.hasor.dataway.daos.ApiInfoQuery;
import net.hasor.dataway.daos.InsertApiQuery;
import net.hasor.dataway.daos.UpdateApiQuery;
import net.hasor.dataway.service.CheckService;
import net.hasor.dataway.web.BasicController;
import net.hasor.db.transaction.Propagation;
import net.hasor.db.transaction.interceptor.Transactional;
import net.hasor.web.annotation.Post;
import net.hasor.web.annotation.QueryParameter;
import net.hasor.web.annotation.RequestBody;
import net.hasor.web.objects.JsonRenderEngine;
import net.hasor.web.render.RenderType;

@MappingToUrl(value="/api/save-api")
@RenderType(value="json", engineType=JsonRenderEngine.class)
public class SaveApiController
extends BasicController {
    @Inject
    private CheckService checkService;

    @Post
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Result<Object> doSave(final @QueryParameter(value="id") String apiId, final @RequestBody Map<String, Object> requestBody) throws Throwable {
        QueryResult queryResult;
        if (!apiId.equalsIgnoreCase(requestBody.get("id").toString())) {
            throw new IllegalArgumentException("id Parameters of the ambiguity.");
        }
        HintsSet query = null;
        if ("-1".equalsIgnoreCase(apiId)) {
            this.checkService.checkApi((String)requestBody.get("apiPath"));
            query = new InsertApiQuery(this.dataQL);
        } else {
            queryResult = new ApiInfoQuery(this.dataQL).execute(new HashMap<String, String>(){
                {
                    this.put("apiId", apiId);
                }
            });
            int status = ((ObjectModel)queryResult.getData()).getValue("status").asInt();
            requestBody.put("newStatus", status == 1 || status == 2 ? 2 : 0);
            query = new UpdateApiQuery(this.dataQL);
        }
        queryResult = query.execute(new HashMap<String, Object>(){
            {
                this.put("postData", requestBody);
            }
        });
        return Result.of(queryResult.getData().unwrap());
    }
}

