/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.web;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.hasor.dataql.QueryResult;
import net.hasor.dataql.domain.ObjectModel;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.config.MappingToUrl;
import net.hasor.dataway.config.Result;
import net.hasor.dataway.daos.ApiDetailQuery;
import net.hasor.dataway.service.ApiCallService;
import net.hasor.dataway.spi.ApiInfo;
import net.hasor.dataway.web.BasicController;
import net.hasor.utils.StringUtils;
import net.hasor.web.annotation.Post;
import net.hasor.web.annotation.QueryParameter;
import net.hasor.web.annotation.RequestBody;
import net.hasor.web.objects.JsonRenderEngine;
import net.hasor.web.render.RenderType;

@MappingToUrl(value="/api/smoke")
@RenderType(value="json", engineType=JsonRenderEngine.class)
public class SmokeController
extends BasicController {
    @Inject
    private ApiCallService apiCallService;

    @Post
    public Result<Object> doSmoke(final @QueryParameter(value="id") String apiId, @RequestBody Map<String, Object> requestBody) throws Throwable {
        if (!apiId.equalsIgnoreCase(requestBody.get("id").toString())) {
            throw new IllegalArgumentException("id Parameters of the ambiguity.");
        }
        QueryResult queryDetail = new ApiDetailQuery(this.dataQL).execute(new HashMap<String, String>(){
            {
                this.put("apiId", apiId);
            }
        });
        ObjectModel objectModel = (ObjectModel)queryDetail.getData();
        ApiInfo apiInfo = new ApiInfo();
        apiInfo.setPerform(true);
        apiInfo.setApiID(apiId);
        apiInfo.setReleaseID("");
        apiInfo.setMethod(objectModel.getValue("select").asString());
        apiInfo.setApiPath(objectModel.getValue("path").asString());
        String strCodeType = objectModel.getValue("codeType").asString();
        String strCodeValue = objectModel.getObject("codeInfo").getValue("codeValue").asString();
        String jsonParamValue = objectModel.getObject("codeInfo").getValue("requestBody").asString();
        jsonParamValue = StringUtils.isBlank((String)jsonParamValue) ? "{}" : jsonParamValue;
        apiInfo.setParameterMap((Map<String, Object>)JSON.parseObject((String)jsonParamValue));
        apiInfo.setOptionMap(objectModel.getObject("optionData").unwrap());
        Object objectMap = this.apiCallService.doCallWithoutError(apiInfo, jsonParam -> {
            if ("sql".equalsIgnoreCase(strCodeType)) {
                return DatawayUtils.evalCodeValueForSQL(strCodeValue, jsonParam);
            }
            return strCodeValue;
        });
        this.updateSchema(apiId, apiInfo.getParameterMap(), objectMap);
        return Result.of(objectMap);
    }

    private void updateSchema(String apiID, Map<String, Object> requestData, Object responseData) {
    }
}

