/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.config;

import java.util.Arrays;
import java.util.Comparator;
import net.hasor.dataway.config.DatawayModule;

public enum DataBaseMapping {
    Mysql("MySQL", 0, "default"),
    Oracle("Oracle", 0, "oracle"),
    SqlServer2012("Microsoft SQL Server", 14, "sqlserver2012"),
    PostgreSQL("PostgreSQL", 9, "postgresql");

    private String dbProductName = null;
    private int minVersion = 0;
    private String mappingType = null;

    private DataBaseMapping(String dbProductName, int minVersion, String mappingType) {
        this.dbProductName = dbProductName;
        this.minVersion = minVersion;
        this.mappingType = mappingType;
    }

    public static DataBaseMapping formName(DatawayModule.DbInfo dbInfo) {
        if (dbInfo == null) {
            return null;
        }
        String productTag = dbInfo.productName.toLowerCase();
        return Arrays.stream(DataBaseMapping.values()).sorted(Comparator.comparingInt(o -> o.minVersion)).filter(dataBaseMapping -> {
            boolean productTest = productTag.contains(dataBaseMapping.dbProductName.toLowerCase());
            boolean versionTest = dbInfo.majorVersion >= dataBaseMapping.minVersion;
            return productTest && versionTest;
        }).findFirst().orElse(null);
    }

    public String mappingType() {
        return this.mappingType;
    }
}

