/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.config;

import java.sql.SQLException;
import net.hasor.core.AppContext;
import net.hasor.core.Environment;
import net.hasor.dataql.DataQL;
import net.hasor.dataql.QueryApiBinder;
import net.hasor.dataql.fx.db.runsql.SqlFragment;
import net.hasor.dataway.DatawayService;
import net.hasor.dataway.config.DataBaseMapping;
import net.hasor.dataway.config.DatawayFinder;
import net.hasor.dataway.config.InterfaceApiFilter;
import net.hasor.dataway.config.InterfaceUiFilter;
import net.hasor.dataway.config.MappingToUrl;
import net.hasor.dataway.service.DatawayServiceImpl;
import net.hasor.dataway.web.ApiDetailController;
import net.hasor.dataway.web.ApiHistoryGetController;
import net.hasor.dataway.web.ApiHistoryListController;
import net.hasor.dataway.web.ApiInfoController;
import net.hasor.dataway.web.ApiListController;
import net.hasor.dataway.web.DeleteController;
import net.hasor.dataway.web.DisableController;
import net.hasor.dataway.web.PerformController;
import net.hasor.dataway.web.PublishController;
import net.hasor.dataway.web.SaveApiController;
import net.hasor.dataway.web.SmokeController;
import net.hasor.dataway.web.Swagger2Controller;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.utils.StringUtils;
import net.hasor.web.WebApiBinder;
import net.hasor.web.WebModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatawayModule
implements WebModule {
    protected static Logger logger = LoggerFactory.getLogger(DatawayModule.class);
    public static final String ISOLATION_CONTEXT = "net.hasor.dataway.config.DatawayModule";
    private boolean datawayApi;
    private boolean datawayAdmin;

    public void loadModule(WebApiBinder apiBinder) {
        Class[] controllerSet;
        Environment environment = apiBinder.getEnvironment();
        this.datawayApi = Boolean.parseBoolean(environment.getVariable("HASOR_DATAQL_DATAWAY"));
        this.datawayAdmin = Boolean.parseBoolean(environment.getVariable("HASOR_DATAQL_DATAWAY_ADMIN"));
        if (!this.datawayApi) {
            logger.info("dataway is disable.");
            return;
        }
        String apiBaseUri = environment.getVariable("HASOR_DATAQL_DATAWAY_API_URL");
        if (StringUtils.isBlank((String)apiBaseUri)) {
            apiBaseUri = "/api/";
        }
        logger.info("dataway api workAt " + apiBaseUri);
        environment.addVariable("HASOR_DATAQL_DATAWAY_API_URL", apiBaseUri);
        apiBinder.filter(DatawayModule.fixUrl(apiBaseUri + "/*"), new String[0]).through(Integer.MAX_VALUE, (Object)new InterfaceApiFilter(apiBaseUri));
        QueryApiBinder defaultContext = (QueryApiBinder)apiBinder.tryCast(QueryApiBinder.class);
        defaultContext.bindFinder(apiBinder.getProvider(DatawayFinder.class));
        logger.info("dataway self isolation ->net.hasor.dataway.config.DatawayModule");
        QueryApiBinder isolation = defaultContext.isolation(ISOLATION_CONTEXT);
        isolation.bindFragment("sql", SqlFragment.class);
        apiBinder.bindType(DatawayService.class).to(DatawayServiceImpl.class);
        if (!this.datawayAdmin) {
            logger.info("dataway admin is disable.");
            return;
        }
        String uiBaseUri = environment.getVariable("HASOR_DATAQL_DATAWAY_UI_URL");
        if (StringUtils.isBlank((String)uiBaseUri)) {
            uiBaseUri = "/interface-ui/";
        }
        if (!uiBaseUri.endsWith("/")) {
            uiBaseUri = uiBaseUri + "/";
        }
        logger.info("dataway admin workAt " + uiBaseUri);
        for (Class aClass : controllerSet = new Class[]{ApiDetailController.class, ApiHistoryListController.class, ApiInfoController.class, ApiListController.class, ApiHistoryGetController.class, DisableController.class, SmokeController.class, SaveApiController.class, PublishController.class, PerformController.class, DeleteController.class, Swagger2Controller.class}) {
            MappingToUrl toUrl = aClass.getAnnotation(MappingToUrl.class);
            apiBinder.mappingTo(DatawayModule.fixUrl(uiBaseUri + "/" + toUrl.value()), new String[0]).with(aClass);
        }
        apiBinder.filter(DatawayModule.fixUrl(uiBaseUri + "/*"), new String[0]).through(Integer.MAX_VALUE, (Object)new InterfaceUiFilter(apiBaseUri, uiBaseUri));
    }

    public void onStart(AppContext appContext) throws SQLException {
        if (!this.datawayApi) {
            return;
        }
        JdbcTemplate jdbcTemplate = (JdbcTemplate)appContext.getInstance(JdbcTemplate.class);
        if (jdbcTemplate == null) {
            throw new IllegalStateException("jdbcTemplate is not init.");
        }
        String databaseProductName = appContext.getEnvironment().getVariable("HASOR_DATAQL_DATAWAY_FORCE_DBTYPE");
        DataBaseMapping dataBaseType = null;
        if (StringUtils.isBlank((String)databaseProductName)) {
            DbInfo dbInfo = (DbInfo)jdbcTemplate.execute(con -> DbInfo.of(con.getMetaData().getDatabaseProductName(), con.getMetaData().getDatabaseMajorVersion()));
            dataBaseType = DataBaseMapping.formName(dbInfo);
        } else {
            for (DataBaseMapping mapping : DataBaseMapping.values()) {
                if (!StringUtils.equalsIgnoreCase((String)mapping.name(), (String)databaseProductName)) continue;
                dataBaseType = mapping;
                break;
            }
        }
        if (dataBaseType == null) {
            throw new IllegalStateException("unknown DataBaseType -> " + databaseProductName);
        }
        logger.info("dataway dbMapping {}", (Object)dataBaseType.mappingType());
        ((DataQL)appContext.findBindingBean(ISOLATION_CONTEXT, DataQL.class)).addShareVarInstance("dbMapping", (Object)dataBaseType.mappingType().toLowerCase());
    }

    static String fixUrl(String url) {
        return url.replaceAll("/+", "/");
    }

    public static class DbInfo {
        public String productName;
        public int majorVersion;

        public static DbInfo of(String productName, int majorVersion) {
            DbInfo info = new DbInfo();
            info.productName = productName;
            info.majorVersion = majorVersion;
            return info;
        }
    }
}

