/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.spi.SpiTrigger;
import net.hasor.dataql.QueryResult;
import net.hasor.dataql.domain.DataModel;
import net.hasor.dataql.runtime.ThrowRuntimeException;
import net.hasor.dataway.config.Result;
import net.hasor.dataway.spi.ApiInfo;
import net.hasor.dataway.spi.SerializationChainSpi;
import net.hasor.utils.io.IOUtils;
import net.hasor.web.Invoker;
import net.hasor.web.MimeType;

public class DatawayUtils {
    private static final ThreadLocal<Long> localRequestTime = ThreadLocal.withInitial(System::currentTimeMillis);

    public static String evalCodeValueForSQL(String strCodeValue, Map<String, Object> strRequestBody) {
        StringBuilder paramKeyBuilder = new StringBuilder("");
        StringBuilder callKeyBuilder = new StringBuilder("");
        for (String key : strRequestBody.keySet()) {
            paramKeyBuilder.append("`" + key + "`,");
            callKeyBuilder.append("${" + key + "},");
        }
        if (paramKeyBuilder.length() > 0) {
            paramKeyBuilder.deleteCharAt(paramKeyBuilder.length() - 1);
            callKeyBuilder.deleteCharAt(callKeyBuilder.length() - 1);
        }
        strCodeValue = "var tempCall = @@sql(" + paramKeyBuilder.toString() + ")<%" + strCodeValue + "%>;\n";
        strCodeValue = strCodeValue + "return tempCall(" + callKeyBuilder.toString() + ");";
        return strCodeValue;
    }

    public static long resetLocalTime() {
        long currentTimeMillis = System.currentTimeMillis();
        localRequestTime.remove();
        localRequestTime.set(currentTimeMillis);
        return currentTimeMillis;
    }

    public static long currentLostTime() {
        return System.currentTimeMillis() - localRequestTime.get();
    }

    public static boolean isResultStructure(Map<String, Object> optionMap) {
        if (optionMap == null) {
            return true;
        }
        return (Boolean)optionMap.getOrDefault("resultStructure", true);
    }

    public static Result<Object> queryResultToResultWithSpecialValue(Map<String, Object> optionMap, final QueryResult queryResult, Object specialValue) {
        final Object resultValue = specialValue instanceof DataModel ? ((DataModel)specialValue).unwrap() : specialValue;
        if (!DatawayUtils.isResultStructure(optionMap)) {
            return Result.of(resultValue);
        }
        LinkedHashMap<String, Object> resultData = new LinkedHashMap<String, Object>(){
            {
                this.put("success", true);
                this.put("message", "OK");
                this.put("code", queryResult.getCode());
                this.put("lifeCycleTime", DatawayUtils.currentLostTime());
                this.put("executionTime", queryResult.executionTime());
                this.put("value", resultValue);
            }
        };
        return Result.of(DatawayUtils.doResponseFormat(optionMap, (Map<String, Object>)resultData));
    }

    public static Result<Object> exceptionToResult(Throwable e) {
        if (e instanceof ThrowRuntimeException) {
            return DatawayUtils.exceptionToResultWithSpecialValue(null, e, ((ThrowRuntimeException)e).getResult().unwrap());
        }
        return DatawayUtils.exceptionToResultWithSpecialValue(null, e, e.getMessage());
    }

    public static Result<Object> exceptionToResultWithSpecialValue(Map<String, Object> optionMap, Throwable e, Object specialValue) {
        if (!DatawayUtils.isResultStructure(optionMap) && specialValue != null) {
            return Result.of(specialValue);
        }
        LinkedHashMap<String, Object> resultData = null;
        if (e instanceof ThrowRuntimeException) {
            resultData = new LinkedHashMap<String, Object>();
            resultData.put("success", false);
            resultData.put("message", e.getMessage());
            resultData.put("code", ((ThrowRuntimeException)e).getThrowCode());
            resultData.put("lifeCycleTime", DatawayUtils.currentLostTime());
            resultData.put("executionTime", ((ThrowRuntimeException)e).getExecutionTime());
            resultData.put("value", specialValue);
        } else {
            resultData = new LinkedHashMap();
            resultData.put("success", false);
            resultData.put("message", e.getMessage());
            resultData.put("code", 500);
            resultData.put("lifeCycleTime", DatawayUtils.currentLostTime());
            resultData.put("executionTime", -1);
            resultData.put("value", specialValue);
        }
        return Result.of(DatawayUtils.doResponseFormat(optionMap, resultData));
    }

    private static Object doResponseFormat(Map<String, Object> optionMap, Map<String, Object> resultData) {
        if (optionMap == null || !optionMap.containsKey("responseFormat")) {
            return resultData;
        }
        Object responseFormat = optionMap.get("responseFormat");
        LinkedHashMap<String, Object> finalResult = new LinkedHashMap<String, Object>();
        LinkedHashMap jsonObject = (LinkedHashMap)JSONObject.parseObject((String)responseFormat.toString(), LinkedHashMap.class);
        block16: for (Object key : jsonObject.keySet()) {
            Object value = jsonObject.get(key);
            if (value == null) {
                finalResult.put(key.toString(), null);
                continue;
            }
            switch (value.toString()) {
                case "@resultStatus": {
                    finalResult.put(key.toString(), resultData.get("success"));
                    continue block16;
                }
                case "@resultMessage": {
                    finalResult.put(key.toString(), resultData.get("message"));
                    continue block16;
                }
                case "@resultCode": {
                    finalResult.put(key.toString(), resultData.get("code"));
                    continue block16;
                }
                case "@timeLifeCycle": {
                    finalResult.put(key.toString(), resultData.get("lifeCycleTime"));
                    continue block16;
                }
                case "@timeExecution": {
                    finalResult.put(key.toString(), resultData.get("executionTime"));
                    continue block16;
                }
                case "@resultData": {
                    finalResult.put(key.toString(), resultData.get("value"));
                    continue block16;
                }
            }
            finalResult.put(key.toString(), value);
        }
        return finalResult;
    }

    public static byte[] toBytes(ApiInfo apiInfo, String body) {
        if (apiInfo.isPerform()) {
            return body.getBytes(StandardCharsets.UTF_8);
        }
        return body.getBytes();
    }

    public static Object responseData(SpiTrigger spiTrigger, ApiInfo apiInfo, String mimeType, Invoker invoker, Object objectMap) throws IOException {
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        HttpServletResponse httpResponse = invoker.getHttpResponse();
        if (!httpResponse.isCommitted()) {
            byte[] bodyByte;
            Object resultData = spiTrigger.chainSpi(SerializationChainSpi.class, (listener, lastResult) -> listener.doSerialization(apiInfo, (MimeType)invoker, lastResult), objectMap);
            if (resultData instanceof SerializationChainSpi.SerializationInfo) {
                mimeType = ((SerializationChainSpi.SerializationInfo)resultData).getMimeType();
                resultData = ((SerializationChainSpi.SerializationInfo)resultData).getData();
            }
            String responseContextType = null;
            int dataLength = -1;
            InputStream bodyInputStream = null;
            if (resultData instanceof String) {
                responseContextType = "text";
                bodyByte = DatawayUtils.toBytes(apiInfo, (String)resultData);
                dataLength = bodyByte.length;
                bodyInputStream = new ByteArrayInputStream(bodyByte);
            } else if (resultData instanceof byte[]) {
                responseContextType = "bytes";
                bodyByte = (byte[])resultData;
                dataLength = bodyByte.length;
                bodyInputStream = new ByteArrayInputStream(bodyByte);
            } else if (resultData instanceof InputStream) {
                responseContextType = "bytes";
                dataLength = -1;
                bodyInputStream = (InputStream)resultData;
            } else {
                responseContextType = "json";
                String body = JSON.toJSONString((Object)resultData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                byte[] bodyByte2 = DatawayUtils.toBytes(apiInfo, body);
                dataLength = bodyByte2.length;
                bodyInputStream = new ByteArrayInputStream(bodyByte2);
            }
            if (dataLength > 0) {
                httpResponse.setContentLength(dataLength);
            }
            if ("true".equalsIgnoreCase(httpRequest.getHeader("X-InterfaceUI-Info"))) {
                httpResponse.setHeader("X-InterfaceUI-ContextType", responseContextType);
            }
            httpResponse.setContentType(mimeType);
            try (ServletOutputStream output = httpResponse.getOutputStream();){
                IOUtils.copy((InputStream)bodyInputStream, (OutputStream)output);
                output.flush();
            }
        }
        return objectMap;
    }
}

