/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.service;

import java.util.HashMap;
import java.util.Map;
import net.hasor.core.Inject;
import net.hasor.core.Singleton;
import net.hasor.core.Type;
import net.hasor.dataql.DataQL;
import net.hasor.dataql.QueryResult;
import net.hasor.dataql.domain.ObjectModel;
import net.hasor.dataway.DatawayService;
import net.hasor.dataway.daos.ReleaseDetailQuery;
import net.hasor.dataway.service.ApiCallService;
import net.hasor.dataway.spi.ApiInfo;

@Singleton
public class DatawayServiceImpl
implements DatawayService {
    @Inject(value="net.hasor.dataway.config.DatawayModule", byType=Type.ByName)
    private DataQL dataQL;
    @Inject
    private ApiCallService callService;

    @Override
    public Object invokeApi(String method, final String apiPath, Map<String, Object> jsonParam) throws Throwable {
        final String httpMethod = method.trim().toUpperCase();
        ApiInfo apiInfo = new ApiInfo();
        QueryResult queryResult = new ReleaseDetailQuery(this.dataQL).execute(new HashMap<String, String>(){
            {
                this.put("apiMethod", httpMethod);
                this.put("apiPath", apiPath);
            }
        });
        ObjectModel dataModel = (ObjectModel)queryResult.getData();
        apiInfo.setApiID(dataModel.getValue("apiID").asString());
        apiInfo.setReleaseID(dataModel.getValue("releaseID").asString());
        apiInfo.setMethod(httpMethod);
        apiInfo.setApiPath(apiPath);
        apiInfo.setParameterMap(jsonParam);
        String script = dataModel.getValue("script").asString();
        return this.callService.doCall(apiInfo, param -> script);
    }
}

