/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.web;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import net.hasor.dataql.QueryResult;
import net.hasor.dataql.domain.DomainHelper;
import net.hasor.dataql.domain.ObjectModel;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.config.MappingToUrl;
import net.hasor.dataway.daos.ApiDetailQuery;
import net.hasor.dataway.daos.UpdateSchemaQuery;
import net.hasor.dataway.schema.types.Type;
import net.hasor.dataway.schema.types.TypesUtils;
import net.hasor.dataway.service.ApiCallService;
import net.hasor.dataway.spi.ApiInfo;
import net.hasor.dataway.web.BasicController;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.annotation.Post;
import net.hasor.web.annotation.QueryParameter;
import net.hasor.web.annotation.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappingToUrl(value="/api/smoke")
public class SmokeController
extends BasicController {
    protected static Logger logger = LoggerFactory.getLogger(SmokeController.class);
    @Inject
    private ApiCallService apiCallService;

    @Post
    public void doSmoke(final @QueryParameter(value="id") String apiId, @RequestBody Map<String, Object> requestBody, Invoker invoker) throws Throwable {
        if (!apiId.equalsIgnoreCase(requestBody.get("id").toString())) {
            throw new IllegalArgumentException("id Parameters of the ambiguity.");
        }
        QueryResult queryDetail = new ApiDetailQuery(this.dataQL).execute(new HashMap<String, String>(){
            {
                this.put("apiId", apiId);
            }
        });
        ObjectModel objectModel = (ObjectModel)queryDetail.getData();
        ApiInfo apiInfo = new ApiInfo();
        apiInfo.setPerform(true);
        apiInfo.setApiID(apiId);
        apiInfo.setReleaseID("");
        apiInfo.setMethod(objectModel.getValue("select").asString());
        apiInfo.setApiPath(objectModel.getValue("path").asString());
        String strCodeType = objectModel.getValue("codeType").asString();
        String strCodeValue = objectModel.getObject("codeInfo").getValue("codeValue").asString();
        String jsonParamValue = objectModel.getObject("codeInfo").getValue("requestBody").asString();
        jsonParamValue = StringUtils.isBlank((String)jsonParamValue) ? "{}" : jsonParamValue;
        apiInfo.setParameterMap((Map<String, Object>)JSON.parseObject((String)jsonParamValue));
        apiInfo.setOptionMap(objectModel.getObject("optionData").unwrap());
        Object objectMap = this.apiCallService.doCallWithoutError(apiInfo, jsonParam -> {
            if ("sql".equalsIgnoreCase(strCodeType)) {
                return DatawayUtils.evalCodeValueForSQL(strCodeValue, jsonParam);
            }
            return strCodeValue;
        });
        this.updateSchema(apiId, apiInfo.getParameterMap(), objectMap);
        DatawayUtils.responseData(this.spiTrigger, apiInfo, invoker.getMimeType("json"), invoker, objectMap);
    }

    private void updateSchema(final String apiID, Object requestData, Object responseData) throws IOException {
        AtomicInteger atomicInteger = new AtomicInteger();
        String prefixType = "ApiType_" + apiID + "_";
        final Type reqType = TypesUtils.extractType(prefixType, atomicInteger, DomainHelper.convertTo((Object)requestData));
        final Type resType = TypesUtils.extractType(prefixType, atomicInteger, DomainHelper.convertTo((Object)responseData));
        QueryResult result = new UpdateSchemaQuery(this.dataQL).execute(new HashMap<String, Object>(){
            {
                this.put("apiID", apiID);
                this.put("requestSchema", TypesUtils.toJsonSchema(reqType, false));
                this.put("responseSchema", TypesUtils.toJsonSchema(resType, false));
            }
        });
        logger.info("update schema apiID = " + apiID, (Object)(", result = " + JSON.toJSONString((Object)result)));
    }
}

