/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.authorization;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.core.Environment;
import net.hasor.core.Settings;
import net.hasor.core.spi.AppContextAware;
import net.hasor.core.spi.SpiTrigger;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.spi.LoginPerformChainSpi;
import net.hasor.dataway.spi.LoginTokenChainSpi;
import net.hasor.utils.CommonCodeUtils;
import net.hasor.utils.ResourcesUtils;
import net.hasor.utils.io.IOUtils;
import net.hasor.utils.io.output.ByteArrayOutputStream;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerChain;
import net.hasor.web.InvokerFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminUiAuthorization
implements InvokerFilter,
AppContextAware {
    protected static Logger logger = LoggerFactory.getLogger(AdminUiAuthorization.class);
    private final String adminBaseUri;
    private final String loginPageUri;
    private final String loginActionUri;
    private final boolean enableAdminAuthorization;
    private SpiTrigger spiTrigger;
    private final String dwAuthDataCookieName = "DW_AUTH_DATA";
    private final String dwAuthData;
    private byte[] loginPageData;

    public AdminUiAuthorization(String adminBaseUri, Environment environment) throws NoSuchAlgorithmException {
        this.adminBaseUri = adminBaseUri;
        this.loginActionUri = AdminUiAuthorization.fixUrl(adminBaseUri + "/login");
        Settings settings = environment.getSettings();
        this.enableAdminAuthorization = settings.getBoolean("hasor.dataway.authorization.enable", Boolean.valueOf(false));
        String adminUser = settings.getString("hasor.dataway.authorization.username", "admin");
        String adminPassword = settings.getString("hasor.dataway.authorization.password", "admin");
        this.dwAuthData = CommonCodeUtils.MD5.getMD5((String)(adminUser + ":" + adminPassword));
        this.loginPageUri = settings.getString("hasor.dataway.authorization.loginPageUri", AdminUiAuthorization.fixUrl("/META-INF/hasor-framework/dataway-ui//login.html"));
    }

    private static String fixUrl(String url) {
        return url.replaceAll("/+", "/");
    }

    public void setAppContext(AppContext appContext) {
        this.spiTrigger = (SpiTrigger)appContext.getInstance(SpiTrigger.class);
    }

    public Object doInvoke(Invoker invoker, InvokerChain chain) throws Throwable {
        if (!invoker.getRequestPath().startsWith(this.adminBaseUri) || !this.enableAdminAuthorization) {
            return chain.doNext(invoker);
        }
        if (this.checkDwAuthData(invoker)) {
            return chain.doNext(invoker);
        }
        if (invoker.getRequestPath().equalsIgnoreCase(this.loginActionUri) && this.doLogin(invoker)) {
            String contextPath = DatawayUtils.getDwContextPath(invoker, null);
            String redirect = AdminUiAuthorization.fixUrl(contextPath + "/" + this.adminBaseUri);
            invoker.getHttpResponse().sendRedirect(redirect);
            return null;
        }
        return this.responseLoginPage(invoker);
    }

    protected boolean checkDwAuthData(Invoker invoker) throws NoSuchAlgorithmException {
        if (this.spiTrigger.hasSpi(LoginTokenChainSpi.class)) {
            return (Boolean)this.spiTrigger.chainSpi(LoginTokenChainSpi.class, (listener, lastResult) -> lastResult != null ? lastResult.booleanValue() : listener.doLogin(invoker), (Object)false);
        }
        String cookieDwAuthData = this.cookieValue(invoker.getHttpRequest(), this.dwAuthDataCookieName);
        return this.dwAuthData.equalsIgnoreCase(cookieDwAuthData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object responseLoginPage(Invoker invoker) throws IOException, ServletException {
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        HttpServletResponse httpResponse = invoker.getHttpResponse();
        String loginPageUriLowerCase = this.loginPageUri.toLowerCase();
        if (loginPageUriLowerCase.startsWith("forward:")) {
            httpRequest.getRequestDispatcher(this.loginPageUri.substring("forward:".length())).forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            return null;
        }
        if (loginPageUriLowerCase.startsWith("redirect:")) {
            httpResponse.sendRedirect(this.loginPageUri.substring("redirect:".length()));
            return null;
        }
        if (this.loginPageData == null) {
            AdminUiAuthorization adminUiAuthorization = this;
            synchronized (adminUiAuthorization) {
                if (this.loginPageData == null) {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    try (InputStream inputStream = ResourcesUtils.getResourceAsStream((String)this.loginPageUri);){
                        if (inputStream == null) {
                            httpResponse.sendError(404, "not found " + this.loginPageUri);
                            Object var9_12 = null;
                            return var9_12;
                        }
                        IOUtils.copy((InputStream)inputStream, (OutputStream)output);
                        this.loginPageData = output.toByteArray();
                    }
                    catch (Exception e) {
                        logger.error("load " + this.loginPageUri + " failed -> " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        httpResponse.setContentType(invoker.getMimeType("html"));
        httpResponse.setContentLength(this.loginPageData.length);
        try (ServletOutputStream outputStream = httpResponse.getOutputStream();){
            outputStream.write(this.loginPageData);
            outputStream.flush();
            return null;
        }
    }

    protected String cookieValue(HttpServletRequest httpRequest, String cookieName) {
        Cookie[] cookies = httpRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equalsIgnoreCase(cookieName)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    protected boolean doLogin(Invoker invoker) throws NoSuchAlgorithmException {
        String username = invoker.getHttpRequest().getParameter("userName");
        String password = invoker.getHttpRequest().getParameter("userPassword");
        if (this.spiTrigger.hasSpi(LoginPerformChainSpi.class)) {
            return (Boolean)this.spiTrigger.chainSpi(LoginPerformChainSpi.class, (listener, lastResult) -> lastResult != null ? lastResult.booleanValue() : listener.doLogin(invoker), (Object)false);
        }
        String loginDwAuthData = CommonCodeUtils.MD5.getMD5((String)(username + ":" + password));
        if (this.dwAuthData.equalsIgnoreCase(loginDwAuthData)) {
            invoker.getHttpResponse().addCookie(new Cookie(this.dwAuthDataCookieName, loginDwAuthData));
            return true;
        }
        return false;
    }
}

