/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.authorization;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public enum AuthorizationType {
    ApiInfo("api_info", new AuthorizationType[0]),
    ApiList("api_list", new AuthorizationType[0]),
    ApiHistory("api_history", new AuthorizationType[0]),
    ApiEdit("api_edit", new AuthorizationType[0]),
    ApiPublish("api_publish", new AuthorizationType[0]),
    ApiDisable("api_disable", new AuthorizationType[0]),
    ApiDelete("api_delete", new AuthorizationType[0]),
    ApiExecute("api_execute", new AuthorizationType[0]),
    Group_Full("group_full", new AuthorizationType[]{ApiInfo, ApiList, ApiHistory, ApiEdit, ApiPublish, ApiDisable, ApiDelete, ApiExecute}),
    Group_ReadOnly("group_readonly", new AuthorizationType[]{ApiList, ApiInfo, ApiHistory}),
    Group_Execute("group_execute", new AuthorizationType[]{ApiExecute});

    private final String authorizationCode;
    private final AuthorizationType[] sameAre;

    private AuthorizationType(String authorizationCode, AuthorizationType[] sameAre) {
        this.authorizationCode = authorizationCode;
        this.sameAre = sameAre == null ? new AuthorizationType[]{} : sameAre;
    }

    public Set<String> toCodeSet() {
        HashSet<String> hasCodes = new HashSet<String>();
        hasCodes.add(this.authorizationCode);
        hasCodes.addAll(Arrays.stream(this.sameAre).map(authorizationType -> authorizationType.authorizationCode).collect(Collectors.toList()));
        return hasCodes;
    }

    public boolean testAuthorization(Set<String> codeSet) {
        Set<String> hasCodes = this.toCodeSet();
        hasCodes.retainAll(codeSet);
        return !hasCodes.isEmpty();
    }
}

