/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.config;

import java.util.function.Supplier;
import net.hasor.core.ApiBinder;
import net.hasor.core.Environment;
import net.hasor.core.HasorUtils;
import net.hasor.core.Settings;
import net.hasor.core.XmlNode;
import net.hasor.core.spi.AppContextAware;
import net.hasor.dataway.DatawayService;
import net.hasor.dataway.authorization.AdminUiAuthorization;
import net.hasor.dataway.authorization.InterfaceAuthorizationFilter;
import net.hasor.dataway.config.InnerApiDalCreator;
import net.hasor.dataway.config.MappingToUrl;
import net.hasor.dataway.config.UiConfig;
import net.hasor.dataway.dal.ApiDataAccessLayer;
import net.hasor.dataway.service.DatawayServiceImpl;
import net.hasor.dataway.service.InterfaceApiFilter;
import net.hasor.dataway.service.InterfaceUiFilter;
import net.hasor.dataway.web.ApiDetailController;
import net.hasor.dataway.web.ApiHistoryGetController;
import net.hasor.dataway.web.ApiHistoryListController;
import net.hasor.dataway.web.ApiInfoController;
import net.hasor.dataway.web.ApiListController;
import net.hasor.dataway.web.DeleteController;
import net.hasor.dataway.web.DisableController;
import net.hasor.dataway.web.GlobalConfigController;
import net.hasor.dataway.web.PerformController;
import net.hasor.dataway.web.PublishController;
import net.hasor.dataway.web.SaveApiController;
import net.hasor.dataway.web.SmokeController;
import net.hasor.dataway.web.Swagger2Controller;
import net.hasor.utils.StringUtils;
import net.hasor.web.WebApiBinder;
import net.hasor.web.WebModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatawayModule
implements WebModule,
UiConfig {
    protected static Logger logger = LoggerFactory.getLogger(DatawayModule.class);

    public void loadModule(WebApiBinder apiBinder) throws Throwable {
        String adminBaseUri;
        Environment environment = apiBinder.getEnvironment();
        Settings settings = environment.getSettings();
        boolean datawayApi = settings.getBoolean("hasor.dataway.enable", Boolean.valueOf(false));
        boolean datawayAdmin = settings.getBoolean("hasor.dataway.enableAdmin", Boolean.valueOf(false));
        if (!datawayApi) {
            logger.info("dataway is disable.");
            return;
        }
        String apiBaseUri = settings.getString("hasor.dataway.baseApiUrl", "/api/");
        if (StringUtils.isBlank((String)apiBaseUri)) {
            apiBaseUri = "/api/";
        }
        if (!apiBaseUri.endsWith("/")) {
            apiBaseUri = apiBaseUri + "/";
        }
        if (StringUtils.isBlank((String)(adminBaseUri = apiBinder.getEnvironment().getSettings().getString("hasor.dataway.baseAdminUrl", "/interface-ui/")))) {
            adminBaseUri = "/interface-ui/";
        }
        if (!adminBaseUri.endsWith("/")) {
            adminBaseUri = adminBaseUri + "/";
        }
        if (datawayAdmin) {
            this.loadApiService(apiBinder, apiBaseUri, adminBaseUri);
            this.loadAdminService(apiBinder, apiBaseUri, adminBaseUri);
        } else {
            this.loadApiService(apiBinder, apiBaseUri, null);
            logger.info("dataway admin is disable.");
        }
        this.loadDal(apiBinder);
        apiBinder.bindType(DatawayService.class).to(DatawayServiceImpl.class);
    }

    protected void loadApiService(WebApiBinder apiBinder, String apiBaseUri, String adminBaseUri) {
        logger.info("dataway api workAt " + apiBaseUri);
        apiBinder.getEnvironment().getSettings().setSetting("hasor.dataway.baseApiUrl", (Object)apiBaseUri);
        apiBinder.filter(DatawayModule.fixUrl(apiBaseUri + "/*"), new String[0]).through(Integer.MAX_VALUE, (Object)new InterfaceApiFilter(apiBaseUri, adminBaseUri));
    }

    protected void loadAdminService(WebApiBinder apiBinder, String apiBaseUri, String adminBaseUri) throws Exception {
        Class[] controllerSet;
        logger.info("dataway admin workAt " + adminBaseUri);
        apiBinder.getEnvironment().getSettings().setSetting("hasor.dataway.baseAdminUrl", (Object)apiBaseUri);
        for (Class aClass : controllerSet = new Class[]{GlobalConfigController.class, ApiDetailController.class, ApiHistoryListController.class, ApiInfoController.class, ApiListController.class, ApiHistoryGetController.class, DisableController.class, SmokeController.class, SaveApiController.class, PublishController.class, PerformController.class, DeleteController.class, Swagger2Controller.class}) {
            ApiBinder.OptionPropertyBindingBuilder metaDataBinder = apiBinder.bindType(aClass).asEagerSingleton();
            metaDataBinder.metaData("KEY_DATAWAY_UI_BASE_URI", (Object)adminBaseUri);
            metaDataBinder.metaData("KEY_DATAWAY_API_BASE_URI", (Object)apiBaseUri);
            MappingToUrl toUrl = aClass.getAnnotation(MappingToUrl.class);
            apiBinder.mappingTo(DatawayModule.fixUrl(adminBaseUri + "/" + toUrl.value()), new String[0]).with(metaDataBinder.toInfo());
        }
        AdminUiAuthorization uiAuthorization = new AdminUiAuthorization(adminBaseUri, apiBinder.getEnvironment());
        apiBinder.filter(DatawayModule.fixUrl(adminBaseUri + "/*"), new String[0]).through(Integer.MAX_VALUE, (Object)HasorUtils.autoAware((Environment)apiBinder.getEnvironment(), (AppContextAware)uiAuthorization));
        apiBinder.filter(DatawayModule.fixUrl(adminBaseUri + "/*"), new String[0]).through(Integer.MAX_VALUE, (Object)new InterfaceAuthorizationFilter(adminBaseUri));
        apiBinder.filter(DatawayModule.fixUrl(adminBaseUri + "/*"), new String[0]).through(Integer.MAX_VALUE, (Object)new InterfaceUiFilter(adminBaseUri));
    }

    protected void loadDal(WebApiBinder apiBinder) throws ClassNotFoundException {
        Environment environment = apiBinder.getEnvironment();
        Settings settings = environment.getSettings();
        String dalType = settings.getString("hasor.dataway.dataAccessLayer.dalType", "db");
        if (StringUtils.isBlank((String)dalType)) {
            throw new IllegalArgumentException("dataway dalType is missing.");
        }
        boolean setupProvider = false;
        XmlNode[] nodeArray = settings.getXmlNodeArray("hasor.dataway.dataAccessLayer.provider");
        if (nodeArray != null) {
            for (XmlNode xmlNode : nodeArray) {
                if (!"provider".equalsIgnoreCase(xmlNode.getName())) continue;
                String providerName = xmlNode.getAttribute("name");
                String providerType = xmlNode.getText();
                if (!dalType.equalsIgnoreCase(providerName) || StringUtils.isBlank((String)providerType)) continue;
                setupProvider = true;
                Class<?> loadClass = environment.getClassLoader().loadClass(providerType);
                logger.info("use '" + providerName + "' as the dataAccessLayer, provider = " + loadClass.getName());
                apiBinder.bindType(ApiDataAccessLayer.class).toProvider((Supplier)HasorUtils.autoAware((Environment)environment, (AppContextAware)new InnerApiDalCreator(loadClass)));
                break;
            }
        }
        if (!setupProvider) {
            throw new RuntimeException("DataAccessLayer is not specified.");
        }
    }

    private static String fixUrl(String url) {
        return url.replaceAll("/+", "/");
    }
}

