/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.dal.providers.db;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.hasor.core.AppContext;
import net.hasor.core.Init;
import net.hasor.core.Inject;
import net.hasor.core.Settings;
import net.hasor.core.Singleton;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.dal.ApiDataAccessLayer;
import net.hasor.dataway.dal.EntityDef;
import net.hasor.dataway.dal.FieldDef;
import net.hasor.dataway.dal.QueryCondition;
import net.hasor.dataway.dal.providers.db.InformationStorage;
import net.hasor.dataway.dal.providers.db.InterfaceInfoDal;
import net.hasor.dataway.dal.providers.db.InterfaceReleaseDal;
import net.hasor.db.JdbcUtils;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DataBaseApiDataAccessLayer
implements ApiDataAccessLayer {
    protected static Logger logger = LoggerFactory.getLogger(DataBaseApiDataAccessLayer.class);
    @Inject
    private AppContext appContext;
    private InterfaceInfoDal infoDal;
    private InterfaceReleaseDal releaseDal;

    @Init
    public void init() throws SQLException {
        String tablePrefix;
        InformationStorage informationStorage = (InformationStorage)this.appContext.getInstance(InformationStorage.class);
        JdbcTemplate jdbcTemplate = null;
        jdbcTemplate = informationStorage != null ? new JdbcTemplate(Objects.requireNonNull(informationStorage.getDataSource(), "informationStorage dataSource is null.")) : (JdbcTemplate)this.appContext.getInstance(JdbcTemplate.class);
        if (jdbcTemplate == null) {
            throw new IllegalStateException("jdbcTemplate is not init.");
        }
        Settings settings = (Settings)this.appContext.getInstance(Settings.class);
        String dbType = settings.getString("hasor.dataway.settings.dal_db_type");
        if (StringUtils.isBlank((String)dbType)) {
            dbType = (String)jdbcTemplate.execute(con -> {
                String jdbcUrl = con.getMetaData().getURL();
                String jdbcDriverName = con.getMetaData().getDriverName();
                return JdbcUtils.getDbType((String)jdbcUrl, (String)jdbcDriverName);
            });
        }
        if (dbType == null) {
            logger.warn("dataway dbType unknown.");
        }
        tablePrefix = StringUtils.isBlank((String)(tablePrefix = settings.getString("hasor.dataway.settings.dal_db_table_prefix"))) ? "" : tablePrefix;
        this.infoDal = new InterfaceInfoDal(jdbcTemplate, dbType, tablePrefix + "interface_info");
        this.releaseDal = new InterfaceReleaseDal(jdbcTemplate, dbType, tablePrefix + "interface_release");
        logger.info("dataway dbType is {} ,table names = {}, {}", new Object[]{dbType, this.infoDal.getTableName(), this.releaseDal.getTableName()});
    }

    @Override
    public Map<FieldDef, String> getObjectBy(EntityDef objectType, FieldDef indexKey, String indexValue) {
        try {
            if (EntityDef.INFO == objectType) {
                return this.infoDal.getObjectBy(indexKey, indexValue);
            }
            return this.releaseDal.getObjectBy(indexKey, indexValue);
        }
        catch (SQLException e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<Map<FieldDef, String>> listObjectBy(EntityDef objectType, Map<QueryCondition, Object> conditions) {
        try {
            if (EntityDef.INFO == objectType) {
                return this.infoDal.listObjectBy(conditions);
            }
            return this.releaseDal.listObjectBy(conditions);
        }
        catch (SQLException e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
    }

    @Override
    public String generateId(EntityDef objectType, String apiPath) {
        String newId = DatawayUtils.generateID();
        return (EntityDef.INFO == objectType ? "i_" : "r_") + newId;
    }

    @Override
    public boolean deleteObject(EntityDef objectType, String id) {
        try {
            if (EntityDef.INFO == objectType) {
                return this.infoDal.deleteObject(id);
            }
            return this.releaseDal.deleteObject(id);
        }
        catch (SQLException e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean updateObject(EntityDef objectType, String id, Map<FieldDef, String> newData) {
        try {
            if (EntityDef.INFO == objectType) {
                return this.infoDal.updateObject(id, newData);
            }
            return this.releaseDal.updateObject(id, newData);
        }
        catch (SQLException e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean createObject(EntityDef objectType, Map<FieldDef, String> newData) {
        try {
            if (EntityDef.INFO == objectType) {
                return this.infoDal.createObject(newData);
            }
            return this.releaseDal.createObject(newData);
        }
        catch (SQLException e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
    }
}

