/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.service;

import com.alibaba.fastjson.JSON;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.Inject;
import net.hasor.core.spi.SpiTrigger;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.config.LoggerUtils;
import net.hasor.dataway.dal.ApiDataAccessLayer;
import net.hasor.dataway.dal.ApiStatusEnum;
import net.hasor.dataway.dal.EntityDef;
import net.hasor.dataway.dal.FieldDef;
import net.hasor.dataway.service.ApiCallService;
import net.hasor.dataway.service.CrossDomainService;
import net.hasor.dataway.spi.ApiInfo;
import net.hasor.dataway.spi.CallSource;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerChain;
import net.hasor.web.InvokerConfig;
import net.hasor.web.InvokerFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceApiFilter
implements InvokerFilter {
    protected static Logger logger = LoggerFactory.getLogger(InterfaceApiFilter.class);
    @Inject
    private ApiCallService callService;
    @Inject
    private SpiTrigger spiTrigger;
    @Inject
    private ApiDataAccessLayer dataAccessLayer;
    @Inject
    private CrossDomainService crossDomainService;
    private final String apiBaseUri;
    private final String adminBaseUri;

    public InterfaceApiFilter(String apiBaseUri, String adminBaseUri) {
        this.apiBaseUri = apiBaseUri;
        this.adminBaseUri = adminBaseUri;
    }

    public void init(InvokerConfig config) {
        config.getAppContext().justInject((Object)this);
    }

    public Object doInvoke(Invoker invoker, InvokerChain chain) throws Throwable {
        Object jsonParam;
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        HttpServletResponse httpResponse = invoker.getHttpResponse();
        String requestURI = invoker.getRequestPath();
        String httpMethod = httpRequest.getMethod().toUpperCase().trim();
        if (!requestURI.startsWith(this.apiBaseUri)) {
            return chain.doNext(invoker);
        }
        if (StringUtils.isNotBlank((String)this.adminBaseUri) && requestURI.startsWith(this.adminBaseUri)) {
            return chain.doNext(invoker);
        }
        DatawayUtils.resetLocalTime();
        String mimeType = invoker.getMimeType("json");
        ApiInfo apiInfo = new ApiInfo();
        apiInfo.setCallSource(CallSource.External);
        String script = null;
        try {
            Map<FieldDef, String> object = this.dataAccessLayer.getObjectBy(EntityDef.RELEASE, FieldDef.PATH, requestURI);
            if (object == null) {
                throw new IllegalStateException("API is not published.");
            }
            ApiStatusEnum anEnum = ApiStatusEnum.typeOf(object.get((Object)FieldDef.STATUS));
            if (anEnum != ApiStatusEnum.Published) {
                throw new IllegalStateException("API is not published.");
            }
            String apiMethod = object.get((Object)FieldDef.METHOD);
            if (!StringUtils.equalsIgnoreCase((String)httpMethod, (String)apiMethod)) {
                throw new IllegalStateException("request method are not allowed.");
            }
            apiInfo.setReleaseID(object.get((Object)FieldDef.ID));
            apiInfo.setApiID(object.get((Object)FieldDef.API_ID));
            apiInfo.setMethod(object.get((Object)FieldDef.METHOD));
            apiInfo.setApiPath(object.get((Object)FieldDef.PATH));
            apiInfo.setOptionMap((Map<String, Object>)JSON.parseObject((String)object.get((Object)FieldDef.OPTION)));
            script = object.get((Object)FieldDef.SCRIPT);
        }
        catch (Exception e) {
            Object result = DatawayUtils.exceptionToResult(e).getResult();
            LoggerUtils loggerUtils = LoggerUtils.create().addLog("httpMethod", httpMethod).addLog("apiPath", requestURI).addLog("result", result).logException(e);
            logger.error("requestFailed - " + loggerUtils.toJson(), (Throwable)e);
            return DatawayUtils.responseData(this.spiTrigger, apiInfo, mimeType, invoker, result);
        }
        if ("GET".equalsIgnoreCase(httpMethod)) {
            jsonParam = new HashMap();
            Enumeration parameterNames = httpRequest.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String paramName = (String)parameterNames.nextElement();
                jsonParam.put(paramName + "Arrays", httpRequest.getParameterValues(paramName));
                jsonParam.put(paramName, httpRequest.getParameter(paramName));
            }
        } else {
            String jsonBody = invoker.getJsonBodyString();
            jsonParam = StringUtils.isNotBlank((String)jsonBody) ? JSON.parseObject((String)jsonBody) : new HashMap();
        }
        apiInfo.setParameterMap((Map<String, Object>)jsonParam);
        this.crossDomainService.configureCross(apiInfo, invoker);
        String finalScript = script;
        Object objectMap = this.callService.doCallWithoutError(apiInfo, param -> finalScript);
        return DatawayUtils.responseData(this.spiTrigger, apiInfo, mimeType, invoker, objectMap);
    }
}

