/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.service;

import com.alibaba.fastjson.JSON;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.utils.ResourcesUtils;
import net.hasor.utils.StringUtils;
import net.hasor.utils.io.FilenameUtils;
import net.hasor.utils.io.IOUtils;
import net.hasor.utils.io.output.ByteArrayOutputStream;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerChain;
import net.hasor.web.InvokerFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceUiFilter
implements InvokerFilter {
    protected static Logger logger = LoggerFactory.getLogger(InterfaceUiFilter.class);
    public static final String resourceBaseUri = "/META-INF/hasor-framework/dataway-ui/";
    private String resourceIndexUri = null;
    private final String uiBaseUri;
    private final String uiAdminBaseUri;
    private final Map<String, Integer> resourceSize;

    public InterfaceUiFilter(String uiBaseUri) {
        this.uiBaseUri = uiBaseUri;
        this.uiAdminBaseUri = InterfaceUiFilter.fixUrl(uiBaseUri + "/api/");
        this.resourceIndexUri = InterfaceUiFilter.fixUrl(uiBaseUri + "/index.html");
        this.resourceSize = new ConcurrentHashMap<String, Integer>();
    }

    private static String fixUrl(String url) {
        return url.replaceAll("/+", "/");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doInvoke(Invoker invoker, InvokerChain chain) throws Throwable {
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        HttpServletResponse httpResponse = invoker.getHttpResponse();
        String requestURI = invoker.getRequestPath();
        InterfaceUiFilter.setupInner(invoker);
        if (requestURI.startsWith(this.uiAdminBaseUri)) {
            try {
                DatawayUtils.resetLocalTime();
                return chain.doNext(invoker);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                Object objectMap = DatawayUtils.exceptionToResult(e).getResult();
                PrintWriter writer = httpResponse.getWriter();
                writer.write(JSON.toJSONString((Object)objectMap));
                writer.flush();
                return objectMap;
            }
        }
        String httpMethod = httpRequest.getMethod().toUpperCase().trim();
        if (httpMethod.equals("OPTIONS")) {
            httpResponse.setStatus(200);
            return httpResponse;
        }
        if (this.uiBaseUri.equalsIgnoreCase(requestURI)) {
            requestURI = this.resourceIndexUri;
        }
        if (requestURI.equalsIgnoreCase(this.resourceIndexUri)) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (InputStream inputStream = ResourcesUtils.getResourceAsStream((String)InterfaceUiFilter.fixUrl("/META-INF/hasor-framework/dataway-ui//index.html"));){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            String htmlBody = new String(outputStream.toByteArray());
            httpResponse.setContentType(invoker.getMimeType("html"));
            httpResponse.setContentLength(htmlBody.length());
            PrintWriter writer = httpResponse.getWriter();
            writer.write(htmlBody);
            writer.flush();
            return null;
        }
        if (!requestURI.startsWith(this.uiBaseUri)) return chain.doNext(invoker);
        String extension = FilenameUtils.getExtension((String)requestURI);
        String mimeType = invoker.getMimeType(extension);
        if (StringUtils.isNotBlank((String)mimeType)) {
            httpResponse.setContentType(mimeType);
        }
        httpResponse.setHeader("Cache-control", "public, max-age=2592000");
        String resourceName = InterfaceUiFilter.fixUrl(resourceBaseUri + requestURI.substring(this.uiBaseUri.length()));
        try (ServletOutputStream outputStream = httpResponse.getOutputStream();){
            ServletOutputStream output = null;
            Integer size = this.resourceSize.get(resourceName);
            if (size == null) {
                output = new ByteArrayOutputStream();
            } else {
                output = outputStream;
                httpResponse.setContentLength(size.intValue());
            }
            try {
                Throwable throwable;
                InputStream inputStream;
                block56: {
                    Object var16_29;
                    block57: {
                        inputStream = ResourcesUtils.getResourceAsStream((String)resourceName);
                        throwable = null;
                        if (inputStream != null) break block56;
                        httpResponse.sendError(404, "not found " + requestURI);
                        var16_29 = null;
                        if (inputStream == null) return var16_29;
                        if (throwable == null) break block57;
                        try {
                            inputStream.close();
                            return var16_29;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return var16_29;
                        }
                    }
                    inputStream.close();
                    return var16_29;
                }
                try {
                    IOUtils.copy((InputStream)inputStream, (OutputStream)output);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("load " + resourceName + " failed -> " + e.getMessage(), (Throwable)e);
            }
            if (size == null) {
                byte[] byteArray = ((ByteArrayOutputStream)output).toByteArray();
                size = byteArray.length;
                this.resourceSize.put(resourceName, size);
                outputStream.write(byteArray);
            }
            outputStream.flush();
            return null;
        }
    }

    public static void setupInner(Invoker invoker) {
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        HttpServletResponse httpResponse = invoker.getHttpResponse();
        String originString = httpRequest.getHeader("Origin");
        if (StringUtils.isNotBlank((String)originString)) {
            httpResponse.setHeader("Access-Control-Allow-Origin", originString);
            httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
        } else {
            httpResponse.setHeader("Access-Control-Allow-Origin", "*");
        }
        httpResponse.addHeader("Access-Control-Allow-Methods", "*");
        httpResponse.addHeader("Access-Control-Allow-Headers", "Content-Type,X-InterfaceUI-Info");
        httpResponse.addHeader("Access-Control-Expose-Headers", "X-InterfaceUI-ContextType");
        httpResponse.addHeader("Access-Control-Max-Age", "3600");
    }
}

