/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.spi;

import java.io.InputStream;
import java.util.EventListener;
import net.hasor.dataway.spi.ApiInfo;
import net.hasor.web.MimeType;

public interface SerializationChainSpi
extends EventListener {
    public Object doSerialization(ApiInfo var1, MimeType var2, Object var3);

    public static class SerializationInfo {
        private String contentType = null;
        private String contentDisposition = null;
        private long contentLength = -1L;
        private Object data = null;

        public String getContentType() {
            return this.contentType;
        }

        public String getContentDisposition() {
            return this.contentDisposition;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public Object getData() {
            return this.data;
        }

        public static SerializationInfo ofString(String contentType, String data) {
            return SerializationInfo.of(contentType, data);
        }

        public static SerializationInfo ofBytes(String contentType, byte[] data) {
            return SerializationInfo.of(contentType, data, null, data.length);
        }

        public static SerializationInfo ofBytes(String contentType, byte[] data, String disposition) {
            return SerializationInfo.of(contentType, data, disposition, data.length);
        }

        public static SerializationInfo ofObject(String contentType, Object data) {
            return SerializationInfo.of(contentType, data);
        }

        public static SerializationInfo ofStream(String contentType, InputStream data) {
            return SerializationInfo.of(contentType, data);
        }

        public static SerializationInfo ofStream(String contentType, InputStream data, long contentLength) {
            return SerializationInfo.of(contentType, data, null, contentLength);
        }

        public static SerializationInfo ofStream(String contentType, InputStream data, long contentLength, String disposition) {
            return SerializationInfo.of(contentType, data, disposition, contentLength);
        }

        private static SerializationInfo of(String contentType, Object data) {
            SerializationInfo info = new SerializationInfo();
            info.contentType = contentType;
            info.data = data;
            return info;
        }

        private static SerializationInfo of(String contentType, Object data, String disposition, long contentLength) {
            SerializationInfo info = new SerializationInfo();
            info.contentType = contentType;
            info.contentDisposition = disposition;
            info.contentLength = contentLength;
            info.data = data;
            return info;
        }
    }
}

