/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.web;

import com.alibaba.fastjson.JSONObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.hasor.core.Inject;
import net.hasor.dataql.domain.DomainHelper;
import net.hasor.dataway.config.MappingToUrl;
import net.hasor.dataway.config.Result;
import net.hasor.dataway.service.ApiCallService;
import net.hasor.dataway.service.schema.types.Type;
import net.hasor.dataway.service.schema.types.TypesUtils;
import net.hasor.dataway.web.BasicController;
import net.hasor.utils.convert.ConverterUtils;
import net.hasor.web.annotation.Post;
import net.hasor.web.annotation.QueryParameter;
import net.hasor.web.annotation.RequestBody;
import net.hasor.web.objects.JsonRenderEngine;
import net.hasor.web.render.RenderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappingToUrl(value="/api/analyze-schema")
@RenderType(value="json", engineType=JsonRenderEngine.class)
public class AnalyzeSchemaController
extends BasicController {
    protected static Logger logger = LoggerFactory.getLogger(AnalyzeSchemaController.class);
    @Inject
    private ApiCallService apiCallService;

    @Post
    public Result<Object> doSmoke(@QueryParameter(value="id") String apiId, @RequestBody Map<String, Object> requestBody) {
        if (!apiId.equalsIgnoreCase(requestBody.get("id").toString())) {
            throw new IllegalArgumentException("id Parameters of the ambiguity.");
        }
        Object optionInfo = requestBody.get("optionInfo");
        boolean allParametersBool = false;
        if (optionInfo instanceof Map) {
            Map optionMap = (Map)optionInfo;
            Boolean allParameters = optionMap.getOrDefault("wrapAllParameters", false);
            allParametersBool = (Boolean)ConverterUtils.convert(Boolean.TYPE, (Object)allParameters);
        }
        LinkedHashMap requestParameters = requestBody.get("requestParameters");
        if (allParametersBool) {
            LinkedHashMap tmpData = new LinkedHashMap();
            tmpData.put("root", requestParameters);
            requestParameters = tmpData;
        }
        Type reqType = TypesUtils.extractType("ReqApiType_" + apiId + "_", new AtomicInteger(), DomainHelper.convertTo(requestParameters));
        JSONObject parameterJsonSchema = TypesUtils.toJsonSchema(reqType, false);
        Object requestSchema = requestBody.get("requestSchema");
        return Result.of(parameterJsonSchema);
    }
}

