/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.web;

import java.util.Map;
import net.hasor.dataway.authorization.AuthorizationType;
import net.hasor.dataway.authorization.RefAuthorization;
import net.hasor.dataway.config.MappingToUrl;
import net.hasor.dataway.config.Result;
import net.hasor.dataway.dal.EntityDef;
import net.hasor.dataway.dal.FieldDef;
import net.hasor.dataway.web.BasicController;
import net.hasor.db.Transactional;
import net.hasor.db.transaction.Propagation;
import net.hasor.web.annotation.Post;
import net.hasor.web.annotation.QueryParameter;
import net.hasor.web.annotation.RequestBody;
import net.hasor.web.objects.JsonRenderEngine;
import net.hasor.web.render.RenderType;

@MappingToUrl(value="/api/disable")
@RefAuthorization(value=AuthorizationType.ApiDisable)
@RenderType(value="json", engineType=JsonRenderEngine.class)
public class DisableController
extends BasicController {
    @Post
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Result<Object> doDisable(@QueryParameter(value="id") String apiId, @RequestBody Map<String, Object> requestBody) {
        if (!apiId.equalsIgnoreCase(requestBody.get("id").toString())) {
            throw new IllegalArgumentException("id Parameters of the ambiguity.");
        }
        Map<FieldDef, String> apiObject = this.dataAccessLayer.getObjectBy(EntityDef.INFO, FieldDef.ID, apiId);
        if (apiObject == null) {
            return Result.of(404, "not found Api.");
        }
        return Result.of(this.datawayService.disableApi(apiId));
    }
}

