/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.web;

import java.util.Map;
import net.hasor.core.Inject;
import net.hasor.dataway.authorization.AuthorizationType;
import net.hasor.dataway.authorization.RefAuthorization;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.config.MappingToUrl;
import net.hasor.dataway.service.ApiCallService;
import net.hasor.dataway.spi.ApiInfo;
import net.hasor.dataway.spi.CallSource;
import net.hasor.dataway.web.BasicController;
import net.hasor.db.Transactional;
import net.hasor.db.transaction.Propagation;
import net.hasor.web.Invoker;
import net.hasor.web.annotation.Post;
import net.hasor.web.annotation.QueryParameter;
import net.hasor.web.annotation.RequestBody;

@MappingToUrl(value="/api/perform")
@RefAuthorization(value=AuthorizationType.ApiEdit)
public class PerformController
extends BasicController {
    @Inject
    private ApiCallService apiCallService;

    @Post
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void doPerform(@QueryParameter(value="id") String apiId, @RequestBody Map<String, Object> requestBody, Invoker invoker) throws Throwable {
        if (!apiId.equalsIgnoreCase(requestBody.get("id").toString())) {
            throw new IllegalArgumentException("id Parameters of the ambiguity.");
        }
        ApiInfo apiInfo = new ApiInfo();
        apiInfo.setCallSource(CallSource.InterfaceUI);
        apiInfo.setApiID(apiId);
        apiInfo.setReleaseID("");
        apiInfo.setMethod(requestBody.get("select").toString());
        apiInfo.setApiPath(requestBody.get("apiPath").toString());
        apiInfo.setParameterMap((Map)requestBody.get("requestBody"));
        apiInfo.setOptionMap((Map)requestBody.get("optionInfo"));
        Object objectMap = this.apiCallService.doCallWithoutError(apiInfo, jsonParam -> {
            String strCodeType = requestBody.get("codeType").toString();
            String strCodeValue = requestBody.get("codeValue").toString();
            if ("sql".equalsIgnoreCase(strCodeType)) {
                return DatawayUtils.evalCodeValueForSQL(strCodeValue, jsonParam);
            }
            return strCodeValue;
        });
        DatawayUtils.responseData(this.spiTrigger, apiInfo, invoker.getMimeType("json"), invoker, objectMap);
    }
}

