/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.hasor.core.Inject;
import net.hasor.dataway.authorization.AuthorizationType;
import net.hasor.dataway.authorization.RefAuthorization;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.config.MappingToUrl;
import net.hasor.dataway.config.Result;
import net.hasor.dataway.dal.ApiStatusEnum;
import net.hasor.dataway.dal.ApiTypeEnum;
import net.hasor.dataway.dal.Constant;
import net.hasor.dataway.dal.EntityDef;
import net.hasor.dataway.dal.FieldDef;
import net.hasor.dataway.dal.HeaderData;
import net.hasor.dataway.service.CheckService;
import net.hasor.dataway.web.BasicController;
import net.hasor.db.Transactional;
import net.hasor.db.transaction.Propagation;
import net.hasor.utils.convert.ConverterUtils;
import net.hasor.web.annotation.Post;
import net.hasor.web.annotation.QueryParameter;
import net.hasor.web.annotation.RequestBody;
import net.hasor.web.objects.JsonRenderEngine;
import net.hasor.web.render.RenderType;

@MappingToUrl(value="/api/save-api")
@RefAuthorization(value=AuthorizationType.ApiEdit)
@RenderType(value="json", engineType=JsonRenderEngine.class)
public class SaveApiController
extends BasicController
implements Constant {
    @Inject
    private CheckService checkService;

    @Post
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Result<Object> doSave(@QueryParameter(value="id") String apiId, @RequestBody Map<String, Object> requestBody) {
        boolean result;
        if (!apiId.equalsIgnoreCase(requestBody.get("id").toString())) {
            throw new IllegalArgumentException("id Parameters of the ambiguity.");
        }
        Map<FieldDef, String> apiInfo = null;
        boolean useCreate = false;
        if ("-1".equalsIgnoreCase(apiId)) {
            String apiPath = (String)requestBody.get("apiPath");
            this.checkService.checkApi(apiPath);
            apiId = this.dataAccessLayer.generateId(EntityDef.INFO, apiPath);
            apiInfo = new LinkedHashMap<FieldDef, String>();
            apiInfo.put(FieldDef.ID, apiId);
            apiInfo.put(FieldDef.METHOD, (String)requestBody.get("select"));
            apiInfo.put(FieldDef.PATH, apiPath);
            apiInfo.put(FieldDef.STATUS, String.valueOf(ApiStatusEnum.Editor.typeNum()));
            apiInfo.put(FieldDef.CREATE_TIME, String.valueOf(System.currentTimeMillis()));
            useCreate = true;
        } else {
            apiInfo = this.dataAccessLayer.getObjectBy(EntityDef.INFO, FieldDef.ID, apiId);
            ApiStatusEnum statusEnum = ApiStatusEnum.typeOf(apiInfo.get((Object)FieldDef.STATUS));
            if (statusEnum != ApiStatusEnum.Editor) {
                apiInfo.put(FieldDef.STATUS, String.valueOf(ApiStatusEnum.Changes.typeNum()));
            }
            useCreate = false;
        }
        ApiTypeEnum codeType = Objects.requireNonNull(ApiTypeEnum.typeOf(requestBody.get("codeType")), "Undefined code type");
        apiInfo.put(FieldDef.API_ID, apiInfo.get((Object)FieldDef.ID));
        apiInfo.put(FieldDef.METHOD, (String)requestBody.get("select"));
        apiInfo.put(FieldDef.TYPE, codeType.typeString());
        apiInfo.put(FieldDef.COMMENT, (String)requestBody.get("comment"));
        Map optionInfo = (Map)requestBody.get("optionInfo");
        apiInfo.put(FieldDef.OPTION, JSON.toJSONString((Object)optionInfo));
        apiInfo.put(FieldDef.GMT_TIME, String.valueOf(System.currentTimeMillis()));
        List headerData = (List)requestBody.get("headerData");
        ArrayList headerDataList = new ArrayList();
        headerData.forEach(dataMap -> {
            HeaderData dat = new HeaderData();
            dat.setChecked((Boolean)ConverterUtils.convert(Boolean.TYPE, dataMap.get("checked")));
            dat.setName(dataMap.get("name").toString());
            dat.setValue(dataMap.get("value").toString());
            headerDataList.add(dat);
        });
        apiInfo.put(FieldDef.REQ_HEADER_SAMPLE, JSON.toJSONString(headerDataList));
        apiInfo.put(FieldDef.REQ_BODY_SAMPLE, (String)requestBody.get("requestBody"));
        apiInfo.put(FieldDef.REQ_BODY_SCHEMA, null);
        apiInfo.put(FieldDef.RES_HEADER_SCHEMA, null);
        apiInfo.put(FieldDef.RES_BODY_SCHEMA, null);
        apiInfo.put(FieldDef.RES_HEADER_SAMPLE, null);
        apiInfo.put(FieldDef.RES_BODY_SAMPLE, null);
        String codeValueOri = (String)requestBody.get("codeValue");
        if (ApiTypeEnum.SQL == codeType) {
            String requestBodySample = (String)requestBody.get("requestBody");
            JSONObject strRequestBody = JSON.parseObject((String)requestBodySample);
            strRequestBody = strRequestBody == null ? Collections.emptyMap() : strRequestBody;
            String strCodeValueTarget = DatawayUtils.evalCodeValueForSQL(codeValueOri, (Map<String, Object>)strRequestBody);
            apiInfo.put(FieldDef.SCRIPT_ORI, codeValueOri);
            apiInfo.put(FieldDef.SCRIPT, strCodeValueTarget);
        } else {
            apiInfo.put(FieldDef.SCRIPT_ORI, codeValueOri);
            apiInfo.put(FieldDef.SCRIPT, codeValueOri);
        }
        boolean bl = result = useCreate ? this.dataAccessLayer.createObject(EntityDef.INFO, apiInfo) : this.dataAccessLayer.updateObject(EntityDef.INFO, apiId, apiInfo);
        if (result) {
            return Result.of(apiId);
        }
        throw new IllegalArgumentException("db update failed.");
    }
}

