/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.web;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.hasor.core.Inject;
import net.hasor.dataql.domain.DomainHelper;
import net.hasor.dataway.authorization.AuthorizationType;
import net.hasor.dataway.authorization.RefAuthorization;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.config.MappingToUrl;
import net.hasor.dataway.dal.Constant;
import net.hasor.dataway.dal.EntityDef;
import net.hasor.dataway.dal.FieldDef;
import net.hasor.dataway.dal.HeaderData;
import net.hasor.dataway.service.ApiCallService;
import net.hasor.dataway.service.schema.types.Type;
import net.hasor.dataway.service.schema.types.TypesUtils;
import net.hasor.dataway.spi.ApiInfo;
import net.hasor.dataway.spi.CallSource;
import net.hasor.dataway.web.BasicController;
import net.hasor.db.Transactional;
import net.hasor.db.transaction.Propagation;
import net.hasor.web.Invoker;
import net.hasor.web.annotation.Post;
import net.hasor.web.annotation.QueryParameter;
import net.hasor.web.annotation.RequestBody;
import net.hasor.web.invoker.HttpParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappingToUrl(value="/api/smoke")
@RefAuthorization(value=AuthorizationType.ApiEdit)
public class SmokeController
extends BasicController
implements Constant {
    protected static Logger logger = LoggerFactory.getLogger(SmokeController.class);
    @Inject
    private ApiCallService apiCallService;

    @Post
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void doSmoke(@QueryParameter(value="id") String apiId, @RequestBody Map<String, Object> requestBody, Invoker invoker) throws Throwable {
        if (!apiId.equalsIgnoreCase(requestBody.get("id").toString())) {
            throw new IllegalArgumentException("id Parameters of the ambiguity.");
        }
        Map<FieldDef, String> objectBy = this.dataAccessLayer.getObjectBy(EntityDef.INFO, FieldDef.ID, apiId);
        ApiInfo apiInfo = new ApiInfo();
        apiInfo.setCallSource(CallSource.InterfaceUI);
        apiInfo.setApiID(objectBy.get((Object)FieldDef.ID));
        apiInfo.setReleaseID("");
        apiInfo.setMethod(objectBy.get((Object)FieldDef.METHOD));
        apiInfo.setApiPath(objectBy.get((Object)FieldDef.PATH));
        String strCodeValue = objectBy.get((Object)FieldDef.SCRIPT);
        apiInfo.setParameterMap((Map<String, Object>)JSON.parseObject((String)objectBy.get((Object)FieldDef.REQ_BODY_SAMPLE)));
        apiInfo.setOptionMap((Map<String, Object>)JSON.parseObject((String)objectBy.get((Object)FieldDef.OPTION)));
        List headerDataList = JSON.parseArray((String)objectBy.get((Object)FieldDef.REQ_HEADER_SAMPLE), HeaderData.class);
        HashMap<String, String> reqHeader = new HashMap<String, String>();
        HashMap reqHeaderList = new HashMap();
        headerDataList.forEach(headerData -> {
            if (headerData.isChecked()) {
                reqHeader.put(headerData.getName(), headerData.getValue());
                reqHeaderList.put(headerData.getName(), Collections.singletonList(headerData.getValue()));
            }
        });
        HttpParameters.clearReplaceHeaderArrayMap(reqHeaderList);
        Object resData = this.apiCallService.doCallWithoutError(apiInfo, jsonParam -> strCodeValue);
        this.updateSchema(apiId, objectBy, reqHeader, apiInfo.getParameterMap(), Collections.emptyMap(), resData);
        DatawayUtils.responseData(this.spiTrigger, apiInfo, invoker.getMimeType("json"), invoker, resData);
    }

    private void updateSchema(String apiID, Map<FieldDef, String> objectBy, Map<String, String> reqHeader, Map<String, Object> reqData, Map<String, String> resHeader, Object resData) {
        AtomicInteger atomicInteger = new AtomicInteger();
        Type reqHeaderType = TypesUtils.extractType((String)ReqHeadSchemaPrefix.apply(apiID), atomicInteger, DomainHelper.convertTo(reqHeader));
        Type reqBodyType = TypesUtils.extractType((String)ReqBodySchemaPrefix.apply(apiID), atomicInteger, DomainHelper.convertTo(reqData));
        Type resHeaderType = TypesUtils.extractType((String)ResHeadSchemaPrefix.apply(apiID), atomicInteger, DomainHelper.convertTo(resHeader));
        Type resBodyType = TypesUtils.extractType((String)ResBodySchemaPrefix.apply(apiID), atomicInteger, DomainHelper.convertTo((Object)resData));
        objectBy.put(FieldDef.REQ_HEADER_SCHEMA, TypesUtils.toJsonSchema(reqHeaderType, false).toJSONString());
        objectBy.put(FieldDef.REQ_BODY_SCHEMA, TypesUtils.toJsonSchema(reqBodyType, false).toJSONString());
        objectBy.put(FieldDef.RES_HEADER_SCHEMA, TypesUtils.toJsonSchema(resHeaderType, false).toJSONString());
        objectBy.put(FieldDef.RES_BODY_SCHEMA, TypesUtils.toJsonSchema(resBodyType, false).toJSONString());
        objectBy.put(FieldDef.RES_HEADER_SAMPLE, JSON.toJSONString(resHeader));
        objectBy.put(FieldDef.RES_BODY_SAMPLE, JSON.toJSONString((Object)resData, (boolean)true));
        this.dataAccessLayer.updateObject(EntityDef.INFO, apiID, objectBy);
    }
}

