CREATE TABLE "INTERFACE_INFO" (
  "API_ID"        VARCHAR2(64)    NOT NULL,
  "API_METHOD"    VARCHAR2(12)    NOT NULL,
  "API_PATH"      VARCHAR2(512)   NOT NULL,
  "API_STATUS"    VARCHAR2(4)     NOT NULL,
  "API_COMMENT"   VARCHAR2(255)   NOT NULL,
  "API_TYPE"      VARCHAR2(24)    NOT NULL,
  "API_SCRIPT"    CLOB            NOT NULL,
  "API_SCHEMA"    CLOB            NOT NULL,
  "API_SAMPLE"    CLOB            NOT NULL,
  "API_OPTION"    CLOB            NOT NULL,
  "API_CREATE_TIME" VARCHAR2(32)  NOT NULL,
  "API_GMT_TIME"  VARCHAR2(32)    NOT NULL,
  CONSTRAINT "PK_INTERFACE_INFO" NOT CLUSTER PRIMARY KEY("API_ID")
) STORAGE(ON "MAIN", CLUSTERBTR);

COMMENT ON TABLE "INTERFACE_INFO" IS 'Dataway 中的API';
COMMENT ON COLUMN "INTERFACE_INFO"."API_COMMENT" IS '注释';
COMMENT ON COLUMN "INTERFACE_INFO"."API_CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "INTERFACE_INFO"."API_GMT_TIME" IS '修改时间';
COMMENT ON COLUMN "INTERFACE_INFO"."API_ID" IS 'ID';
COMMENT ON COLUMN "INTERFACE_INFO"."API_METHOD" IS 'HttpMethod：GET、PUT、POST';
COMMENT ON COLUMN "INTERFACE_INFO"."API_OPTION" IS '扩展配置信息';
COMMENT ON COLUMN "INTERFACE_INFO"."API_PATH" IS '拦截路径';
COMMENT ON COLUMN "INTERFACE_INFO"."API_SAMPLE" IS '请求/响应/请求头样本数据';
COMMENT ON COLUMN "INTERFACE_INFO"."API_SCHEMA" IS '接口的请求/响应数据结构';
COMMENT ON COLUMN "INTERFACE_INFO"."API_SCRIPT" IS '查询脚本：xxxxxxx';
COMMENT ON COLUMN "INTERFACE_INFO"."API_STATUS" IS '状态：-1-删除, 0-草稿，1-发布，2-有变更，3-禁用';
COMMENT ON COLUMN "INTERFACE_INFO"."API_TYPE" IS '脚本类型：SQL、DataQL';

CREATE UNIQUE  INDEX "UK_INTERFACE_INFO" ON "INTERFACE_INFO"("API_PATH" ASC) STORAGE(ON "MAIN", CLUSTERBTR);
