/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.authorization;

import java.lang.reflect.Method;
import net.hasor.core.spi.SpiTrigger;
import net.hasor.dataway.DatawayApi;
import net.hasor.dataway.DatawayService;
import net.hasor.dataway.authorization.PermissionType;
import net.hasor.dataway.authorization.RefAuthorization;
import net.hasor.dataway.service.CrossDomainService;
import net.hasor.dataway.spi.AuthorizationChainSpi;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerChain;
import net.hasor.web.InvokerConfig;
import net.hasor.web.InvokerFilter;
import net.hasor.web.Mapping;

public class InterfaceAuthorizationFilter
implements InvokerFilter {
    private SpiTrigger spiTrigger = null;
    private DatawayService datawayService = null;
    private String uiAdminBaseUri = null;
    private CrossDomainService crossDomainService = null;

    public InterfaceAuthorizationFilter(String uiBaseUri) {
        this.uiAdminBaseUri = (uiBaseUri + "/api/").replaceAll("/+", "/");
    }

    public void init(InvokerConfig config) {
        this.spiTrigger = (SpiTrigger)config.getAppContext().getInstance(SpiTrigger.class);
        this.datawayService = (DatawayService)config.getAppContext().getInstance(DatawayService.class);
        this.crossDomainService = (CrossDomainService)config.getAppContext().getInstance(CrossDomainService.class);
    }

    public Object doInvoke(Invoker invoker, InvokerChain chain) throws Throwable {
        if (!invoker.getRequestPath().startsWith(this.uiAdminBaseUri)) {
            return chain.doNext(invoker);
        }
        Mapping mapping = invoker.ownerMapping();
        if (mapping == null) {
            return chain.doNext(invoker);
        }
        Method mappingMethod = mapping.findMethod(invoker.getHttpRequest());
        if (mappingMethod == null) {
            return chain.doNext(invoker);
        }
        RefAuthorization refAuthorization = mappingMethod.getAnnotation(RefAuthorization.class);
        if (refAuthorization == null) {
            refAuthorization = mappingMethod.getDeclaringClass().getAnnotation(RefAuthorization.class);
        }
        PermissionType uiAuthorization = refAuthorization != null ? refAuthorization.value() : null;
        String apiId = null;
        String queryString = invoker.getHttpRequest().getQueryString();
        if (StringUtils.isNotBlank((String)queryString)) {
            for (String queryItem : queryString.split("&")) {
                if (!queryItem.startsWith("id=")) continue;
                apiId = queryItem.split("=")[1];
                break;
            }
        }
        if (uiAuthorization == null) {
            return chain.doNext(invoker);
        }
        DatawayApi datawayApi = StringUtils.isNotBlank(apiId) && !"-1".equalsIgnoreCase(apiId) ? this.datawayService.getApiById(apiId) : null;
        Boolean checkResult = (Boolean)this.spiTrigger.chainSpi(AuthorizationChainSpi.class, (listener, lastResult) -> listener.doCheck(uiAuthorization, datawayApi, (boolean)lastResult), (Object)true);
        if (checkResult.booleanValue()) {
            return chain.doNext(invoker);
        }
        if (datawayApi != null) {
            this.crossDomainService.configureCross(datawayApi, invoker);
        }
        invoker.getHttpResponse().sendError(401, "No permission.");
        return null;
    }
}

