/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.authorization;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.hasor.dataway.authorization.PermissionType;
import net.hasor.utils.StringUtils;

public enum PermissionGroup {
    Group_Full(new PermissionType[]{PermissionType.ApiInfo, PermissionType.ApiList, PermissionType.ApiHistory, PermissionType.ApiEdit, PermissionType.ApiPublish, PermissionType.ApiDisable, PermissionType.ApiDelete, PermissionType.ApiExecute}),
    Group_ReadOnly(new PermissionType[]{PermissionType.ApiList, PermissionType.ApiInfo, PermissionType.ApiHistory}),
    Group_Execute(new PermissionType[]{PermissionType.ApiExecute, PermissionType.ApiPerform});

    private final PermissionType[] permissionTypes;

    private PermissionGroup(PermissionType[] permissionTypes) {
        this.permissionTypes = permissionTypes == null ? new PermissionType[]{} : permissionTypes;
    }

    public Set<String> toCodeSet() {
        return Arrays.stream(this.permissionTypes).map(PermissionType::getPermissionCode).collect(Collectors.toSet());
    }

    public boolean testPermission(PermissionType permissionType) {
        for (PermissionType type : this.permissionTypes) {
            if (type != permissionType) continue;
            return true;
        }
        return false;
    }

    public boolean testPermission(String permissionCode) {
        for (PermissionType type : this.permissionTypes) {
            if (!StringUtils.equals((String)type.getPermissionCode(), (String)permissionCode)) continue;
            return true;
        }
        return false;
    }
}

