/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.spi.SpiTrigger;
import net.hasor.dataql.DataQueryException;
import net.hasor.dataql.QueryResult;
import net.hasor.dataql.domain.DataModel;
import net.hasor.dataql.runtime.ThrowRuntimeException;
import net.hasor.dataway.config.Result;
import net.hasor.dataway.dal.ApiStatusEnum;
import net.hasor.dataway.dal.FieldDef;
import net.hasor.dataway.dal.QueryCondition;
import net.hasor.dataway.spi.ApiInfo;
import net.hasor.dataway.spi.SerializationChainSpi;
import net.hasor.utils.StringUtils;
import net.hasor.utils.io.IOUtils;
import net.hasor.web.Invoker;
import net.hasor.web.MimeType;

public class DatawayUtils {
    private static final ThreadLocal<Long> localRequestTime = ThreadLocal.withInitial(System::currentTimeMillis);
    public static final Supplier<Map<FieldDef, String>> STATUS_UPDATE_TO_EDITOR = () -> new HashMap<FieldDef, String>(){
        {
            this.put(FieldDef.STATUS, String.valueOf(ApiStatusEnum.Editor.typeNum()));
            this.put(FieldDef.GMT_TIME, String.valueOf(System.currentTimeMillis()));
        }
    };
    public static final Supplier<Map<FieldDef, String>> STATUS_UPDATE_TO_PUBLISHED = () -> new HashMap<FieldDef, String>(){
        {
            this.put(FieldDef.STATUS, String.valueOf(ApiStatusEnum.Published.typeNum()));
            this.put(FieldDef.GMT_TIME, String.valueOf(System.currentTimeMillis()));
        }
    };
    public static final Supplier<Map<FieldDef, String>> STATUS_UPDATE_TO_CHANGES = () -> new HashMap<FieldDef, String>(){
        {
            this.put(FieldDef.STATUS, String.valueOf(ApiStatusEnum.Changes.typeNum()));
            this.put(FieldDef.GMT_TIME, String.valueOf(System.currentTimeMillis()));
        }
    };
    public static final Supplier<Map<FieldDef, String>> STATUS_UPDATE_TO_DISABLE = () -> new HashMap<FieldDef, String>(){
        {
            this.put(FieldDef.STATUS, String.valueOf(ApiStatusEnum.Disable.typeNum()));
            this.put(FieldDef.GMT_TIME, String.valueOf(System.currentTimeMillis()));
        }
    };
    public static final Supplier<Map<FieldDef, String>> STATUS_UPDATE_TO_DELETE = () -> new HashMap<FieldDef, String>(){
        {
            this.put(FieldDef.STATUS, String.valueOf(ApiStatusEnum.Delete.typeNum()));
            this.put(FieldDef.GMT_TIME, String.valueOf(System.currentTimeMillis()));
        }
    };

    public static String getDwContextPath(Invoker invoker, String defaultPath) {
        String contextPathProxy;
        String contextPath = invoker.getHttpRequest().getContextPath();
        String contextPathProxy1 = defaultPath;
        String contextPathProxy2 = invoker.getHttpRequest().getHeader("DW_CONTEXT_PATH_PROXY");
        String string = contextPathProxy = StringUtils.isNotBlank((String)contextPathProxy1) ? contextPathProxy1 : contextPathProxy2;
        if (StringUtils.isBlank((String)contextPathProxy)) {
            if (StringUtils.isBlank((String)contextPath)) {
                contextPath = "/";
            }
            if (contextPath.endsWith("/")) {
                contextPath = contextPath.substring(0, contextPath.length() - 1);
            }
        } else {
            contextPath = contextPathProxy;
        }
        return contextPath;
    }

    public static String evalCodeValueForSQL(String strCodeValue, Map<String, Object> strRequestBody) {
        StringBuilder paramKeyBuilder = new StringBuilder("");
        StringBuilder callKeyBuilder = new StringBuilder("");
        for (String key : strRequestBody.keySet()) {
            paramKeyBuilder.append("`" + key + "`,");
            callKeyBuilder.append("${" + key + "},");
        }
        if (paramKeyBuilder.length() > 0) {
            paramKeyBuilder.deleteCharAt(paramKeyBuilder.length() - 1);
            callKeyBuilder.deleteCharAt(callKeyBuilder.length() - 1);
        }
        strCodeValue = "var tempCall = @@sql(" + paramKeyBuilder.toString() + ")<%" + strCodeValue + "%>;\n";
        strCodeValue = strCodeValue + "return tempCall(" + callKeyBuilder.toString() + ");";
        return strCodeValue;
    }

    public static long resetLocalTime() {
        long currentTimeMillis = System.currentTimeMillis();
        localRequestTime.remove();
        localRequestTime.set(currentTimeMillis);
        return currentTimeMillis;
    }

    public static long currentLostTime() {
        return System.currentTimeMillis() - localRequestTime.get();
    }

    public static boolean isResultStructure(Map<String, Object> optionMap) {
        if (optionMap == null) {
            return true;
        }
        return (Boolean)optionMap.getOrDefault("resultStructure", true);
    }

    public static String wrapParameterName(Map<String, Object> optionMap) {
        if (optionMap == null) {
            return null;
        }
        boolean wrapAllParameters = (Boolean)optionMap.getOrDefault("wrapAllParameters", false);
        if (wrapAllParameters) {
            String wrapParameterName = (String)optionMap.getOrDefault("wrapParameterName", "root");
            return StringUtils.isBlank((String)wrapParameterName) ? null : wrapParameterName.trim();
        }
        return null;
    }

    public static Result<Object> queryResultToResultWithSpecialValue(Map<String, Object> optionMap, final QueryResult queryResult, Object specialValue) {
        final Object resultValue = specialValue instanceof DataModel ? ((DataModel)specialValue).unwrap() : specialValue;
        if (!DatawayUtils.isResultStructure(optionMap)) {
            return Result.of(resultValue);
        }
        LinkedHashMap<String, Object> resultData = new LinkedHashMap<String, Object>(){
            {
                this.put("success", true);
                this.put("message", "OK");
                this.put("code", queryResult.getCode());
                this.put("location", null);
                this.put("lifeCycleTime", DatawayUtils.currentLostTime());
                this.put("executionTime", queryResult.executionTime());
                this.put("value", resultValue);
            }
        };
        return Result.of(DatawayUtils.doResponseFormat(optionMap, (Map<String, Object>)resultData));
    }

    public static Result<Object> exceptionToResult(Throwable e) {
        if (e instanceof ThrowRuntimeException) {
            return DatawayUtils.exceptionToResultWithSpecialValue(null, e, ((ThrowRuntimeException)e).getResult().unwrap());
        }
        return DatawayUtils.exceptionToResultWithSpecialValue(null, e, e.getMessage());
    }

    public static Result<Object> exceptionToResultWithSpecialValue(Map<String, Object> optionMap, Throwable e, Object specialValue) {
        if (!DatawayUtils.isResultStructure(optionMap) && specialValue != null) {
            return Result.of(specialValue);
        }
        LinkedHashMap<String, Object> resultData = new LinkedHashMap<String, Object>();
        resultData.put("success", false);
        resultData.put("message", e.getLocalizedMessage());
        resultData.put("value", specialValue);
        resultData.put("lifeCycleTime", DatawayUtils.currentLostTime());
        if (e instanceof ThrowRuntimeException) {
            resultData.put("location", ((ThrowRuntimeException)e).getLocation().toString());
            resultData.put("code", ((ThrowRuntimeException)e).getThrowCode());
            resultData.put("executionTime", ((ThrowRuntimeException)e).getExecutionTime());
        } else if (e instanceof DataQueryException) {
            resultData.put("location", ((DataQueryException)e).getLocation().toString());
            resultData.put("code", 500);
            resultData.put("executionTime", -1);
        } else {
            resultData.put("location", "Unknown");
            resultData.put("code", 500);
            resultData.put("executionTime", -1);
        }
        return Result.of(DatawayUtils.doResponseFormat(optionMap, resultData));
    }

    private static Object doResponseFormat(Map<String, Object> optionMap, Map<String, Object> resultData) {
        if (optionMap == null || !optionMap.containsKey("responseFormat")) {
            return resultData;
        }
        Object responseFormat = optionMap.get("responseFormat");
        LinkedHashMap<String, Object> finalResult = new LinkedHashMap<String, Object>();
        LinkedHashMap jsonObject = (LinkedHashMap)JSONObject.parseObject((String)responseFormat.toString(), LinkedHashMap.class);
        block18: for (Object key : jsonObject.keySet()) {
            Object value = jsonObject.get(key);
            if (value == null) {
                finalResult.put(key.toString(), null);
                continue;
            }
            switch (value.toString()) {
                case "@resultStatus": {
                    finalResult.put(key.toString(), resultData.get("success"));
                    continue block18;
                }
                case "@resultMessage": {
                    finalResult.put(key.toString(), resultData.get("message"));
                    continue block18;
                }
                case "@codeLocation": {
                    finalResult.put(key.toString(), resultData.get("location"));
                    continue block18;
                }
                case "@resultCode": {
                    finalResult.put(key.toString(), resultData.get("code"));
                    continue block18;
                }
                case "@timeLifeCycle": {
                    finalResult.put(key.toString(), resultData.get("lifeCycleTime"));
                    continue block18;
                }
                case "@timeExecution": {
                    finalResult.put(key.toString(), resultData.get("executionTime"));
                    continue block18;
                }
                case "@resultData": {
                    finalResult.put(key.toString(), resultData.get("value"));
                    continue block18;
                }
            }
            finalResult.put(key.toString(), value);
        }
        return finalResult;
    }

    public static Object responseData(SpiTrigger spiTrigger, ApiInfo apiInfo, String contentType, Invoker invoker, Object objectMap) throws IOException {
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        HttpServletResponse httpResponse = invoker.getHttpResponse();
        if (!httpResponse.isCommitted()) {
            Object resultData = spiTrigger.chainSpi(SerializationChainSpi.class, (listener, lastResult) -> listener.doSerialization(apiInfo, (MimeType)invoker, lastResult), objectMap);
            String contentDisposition = null;
            long contentLength = -1L;
            if (resultData instanceof SerializationChainSpi.SerializationInfo) {
                contentType = ((SerializationChainSpi.SerializationInfo)resultData).getContentType();
                contentDisposition = ((SerializationChainSpi.SerializationInfo)resultData).getContentDisposition();
                contentLength = ((SerializationChainSpi.SerializationInfo)resultData).getContentLength();
                resultData = ((SerializationChainSpi.SerializationInfo)resultData).getData();
            }
            if (resultData instanceof String) {
                DatawayUtils.setUIContextType(httpRequest, httpResponse, "text");
                String characterEncoding = httpResponse.getCharacterEncoding();
                DatawayUtils.responseString(httpResponse, contentType, characterEncoding, (String)resultData);
            } else if (resultData instanceof byte[]) {
                DatawayUtils.setUIContextType(httpRequest, httpResponse, "bytes");
                byte[] bodyByte = (byte[])resultData;
                DatawayUtils.responseBytes(httpResponse, contentType, contentDisposition, bodyByte.length, new ByteArrayInputStream(bodyByte));
            } else if (resultData instanceof InputStream) {
                DatawayUtils.setUIContextType(httpRequest, httpResponse, "bytes");
                DatawayUtils.responseBytes(httpResponse, contentType, contentDisposition, contentLength, (InputStream)resultData);
            } else {
                DatawayUtils.setUIContextType(httpRequest, httpResponse, "json");
                String characterEncoding = httpResponse.getCharacterEncoding();
                String body = JSON.toJSONString((Object)resultData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                DatawayUtils.responseString(httpResponse, contentType, characterEncoding, body);
            }
        }
        return objectMap;
    }

    private static void setUIContextType(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String responseContextType) {
        if ("true".equalsIgnoreCase(httpRequest.getHeader("X-InterfaceUI-Info"))) {
            httpResponse.setHeader("X-InterfaceUI-ContextType", responseContextType);
        }
    }

    private static void responseBytes(HttpServletResponse httpResponse, String contentType, String contentDisposition, long contentLength, InputStream bodyInputStream) throws IOException {
        httpResponse.setContentType(contentType);
        if (StringUtils.isNotBlank((String)contentDisposition)) {
            httpResponse.setHeader("Content-Disposition", contentDisposition);
        }
        if (contentLength > 0L) {
            if (contentLength > Integer.MAX_VALUE) {
                httpResponse.setContentLengthLong(contentLength);
            } else {
                httpResponse.setContentLength((int)contentLength);
            }
        }
        try (ServletOutputStream output = httpResponse.getOutputStream();){
            IOUtils.copy((InputStream)bodyInputStream, (OutputStream)output);
            output.flush();
        }
    }

    private static void responseString(HttpServletResponse httpResponse, String contentType, String characterEncoding, String contentBody) throws IOException {
        if (StringUtils.isNotBlank((String)characterEncoding)) {
            contentType = contentType + ";charset=" + characterEncoding;
        }
        if (StringUtils.isNotBlank((String)contentType)) {
            httpResponse.setContentType(contentType);
        }
        try (PrintWriter writer = httpResponse.getWriter();){
            writer.write(contentBody);
            writer.flush();
        }
    }

    public static String generateID() {
        long timeMillis = System.currentTimeMillis();
        int nextInt = new Random(timeMillis).nextInt();
        String s = Integer.toString(nextInt, 24);
        s = s.length() > 4 ? s.substring(0, 4) : StringUtils.rightPad((String)s, (int)4, (String)"0");
        return Long.toString(timeMillis, 24) + s;
    }

    public static Map<QueryCondition, Object> conditionByApiId(final String apiId) {
        return new HashMap<QueryCondition, Object>(){
            {
                this.put(QueryCondition.ApiId, apiId);
            }
        };
    }
}

