/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.config;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.TreeMap;
import net.hasor.utils.builder.ToStringBuilder;
import net.hasor.utils.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerUtils {
    private static final Logger logger = LoggerFactory.getLogger(LoggerUtils.class);
    private final Map<String, Object> map = new TreeMap<String, Object>();

    private LoggerUtils() {
    }

    public static LoggerUtils create() {
        return new LoggerUtils();
    }

    private void put(String key, Object value) {
        if (key != null && this.map.get(key) != null) {
            logger.error("duplicat key = " + key);
        }
        this.map.put(key, value);
        if (this.map.keySet().size() > 20) {
            logger.error("NEED_SMS_NOTIFY map.key.size = " + this.map.keySet().size());
        }
    }

    public LoggerUtils addString(String message) {
        if (message == null) {
            message = "valueIsNull";
        }
        this.put("message", message);
        return this;
    }

    public LoggerUtils addLog(String key, Object value) {
        if (value == null) {
            value = "valueIsNull";
        }
        this.put(key, value);
        return this;
    }

    public LoggerUtils logException(Throwable ex) {
        if (ex != null) {
            this.put("exceptionMsg", ex.getMessage());
        }
        return this;
    }

    public String toJson() {
        return JSONObject.toJSONString(this.map);
    }

    public String toStringBuilder() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> kv : this.map.entrySet()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            String s = null;
            s = kv.getValue() == null ? "null" : (kv.getValue() instanceof String || kv.getValue() instanceof Long || kv.getValue() instanceof Integer || kv.getValue() instanceof Double ? String.valueOf(kv.getValue()) : ToStringBuilder.reflectionToString((Object)kv.getValue(), (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
            sb.append("[" + kv.getKey() + "]=[" + s + "]");
        }
        return sb.toString();
    }
}

