/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.config;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import net.hasor.core.AppContext;
import net.hasor.core.BindInfo;
import net.hasor.core.Module;
import net.hasor.utils.StringUtils;
import net.hasor.web.WebApiBinder;
import net.hasor.web.WebModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosDiscoveryModule
implements WebModule {
    protected static Logger logger = LoggerFactory.getLogger(NacosDiscoveryModule.class);
    private String nacosServerAddr;
    private String nacosNamespace;
    private String nacosGroupName;
    private String serviceName;
    private String serviceIP;
    private int servicePort;
    private String serviceClusterName;
    private NamingService nacosNamingService;
    private boolean registerStatus;

    public void loadModule(WebApiBinder apiBinder) throws SocketException {
        boolean nacosDiscovery = apiBinder.getEnvironment().getSettings().getBoolean("hasor.dataway.settings.dal_nacos_discovery", Boolean.valueOf(false));
        if (!nacosDiscovery) {
            logger.info("nacos Discovery is disable.");
            throw new Module.IgnoreModuleException();
        }
        BindInfo bindInfo = apiBinder.getBindInfo(NamingService.class);
        String nacosServerAddr = apiBinder.getEnvironment().getSettings().getString("hasor.dataway.settings.dal_nacos_addr");
        String nacosNamespace = apiBinder.getEnvironment().getSettings().getString("hasor.dataway.settings.dal_nacos_namespace", "public");
        String nacosGroupName = apiBinder.getEnvironment().getSettings().getString("hasor.dataway.settings.dal_nacos_group", "DEFAULT_GROUP");
        String serviceName = apiBinder.getEnvironment().getSettings().getString("hasor.dataway.settings.dal_nacos_service_name", "app");
        if (bindInfo == null && StringUtils.isBlank((String)nacosServerAddr)) {
            throw new IllegalArgumentException("config dal_nacos_addr is missing.");
        }
        if (bindInfo == null && StringUtils.isBlank((String)nacosNamespace)) {
            throw new IllegalArgumentException("config dal_nacos_namespace is missing.");
        }
        if (StringUtils.isBlank((String)nacosGroupName)) {
            throw new IllegalArgumentException("config dal_nacos_group is missing.");
        }
        if (StringUtils.isBlank((String)serviceName)) {
            throw new IllegalArgumentException("config dal_nacos_service_name is not specified");
        }
        this.nacosServerAddr = nacosServerAddr;
        this.nacosNamespace = nacosNamespace;
        this.nacosGroupName = nacosGroupName;
        this.serviceName = serviceName;
        int nacosDiscoveryPort = apiBinder.getEnvironment().getSettings().getInteger("hasor.dataway.settings.dal_nacos_discovery_port", Integer.valueOf(0));
        if (nacosDiscoveryPort <= 0) {
            throw new IllegalArgumentException("config dal_nacos_service_port is not specified");
        }
        String nacosDiscoveryIP = apiBinder.getEnvironment().getSettings().getString("hasor.dataway.settings.dal_nacos_discovery_ip");
        String nacosDiscoveryPrefix = apiBinder.getEnvironment().getSettings().getString("hasor.dataway.settings.dal_nacos_discovery_prefix");
        String nacosDiscoveryNetworkInterface = apiBinder.getEnvironment().getSettings().getString("hasor.dataway.settings.dal_nacos_discovery_networkInterface");
        String nacosClusterName = apiBinder.getEnvironment().getSettings().getString("hasor.dataway.settings.dal_nacos_cluster_name");
        this.servicePort = nacosDiscoveryPort;
        this.serviceClusterName = nacosClusterName;
        if (StringUtils.isBlank((String)nacosDiscoveryIP) && StringUtils.isBlank((String)nacosDiscoveryPrefix) && StringUtils.isBlank((String)nacosDiscoveryNetworkInterface)) {
            throw new IllegalArgumentException("must config dal_nacos_discovery_ip or dal_nacos_discovery_prefix or dal_nacos_discovery_networkInterface");
        }
        if (StringUtils.isNotBlank((String)nacosDiscoveryIP)) {
            this.serviceIP = nacosDiscoveryIP;
            return;
        }
        HashSet<NetworkInterface> interfaces = new HashSet<NetworkInterface>();
        if (StringUtils.isNotBlank((String)nacosDiscoveryNetworkInterface)) {
            HashSet<String> match = new HashSet<String>(Arrays.asList(nacosDiscoveryNetworkInterface.split(",")));
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface nextElement = networkInterfaces.nextElement();
                if (match.isEmpty()) {
                    interfaces.add(nextElement);
                    continue;
                }
                if (!match.contains(nextElement.getName())) continue;
                interfaces.add(nextElement);
            }
        }
        HashSet<String> foundNetwork = new HashSet<String>();
        for (NetworkInterface networkInterface : interfaces) {
            Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
            while (enumeration.hasMoreElements()) {
                InetAddress nextElement = enumeration.nextElement();
                String hostAddress = nextElement.getHostAddress();
                if (!StringUtils.isBlank((String)nacosDiscoveryPrefix) && !hostAddress.startsWith(nacosDiscoveryPrefix)) continue;
                foundNetwork.add(hostAddress);
            }
        }
        this.serviceIP = foundNetwork.stream().findAny().orElse(null);
    }

    public void onStart(AppContext appContext) throws Throwable {
        this.nacosNamingService = (NamingService)appContext.getInstance(NamingService.class);
        if (this.nacosNamingService == null) {
            Properties properties = new Properties();
            properties.put("serverAddr", this.nacosServerAddr);
            properties.put("namespace", this.nacosNamespace);
            this.nacosNamingService = NacosFactory.createNamingService((Properties)properties);
            logger.info("nacosNaming init NamingService, serverAddr = " + this.nacosServerAddr + ", namespace=" + this.nacosNamespace);
        } else {
            logger.info("nacosNaming Containers provide NamingService.");
        }
        List allInstances = this.nacosNamingService.getAllInstances(this.serviceName, this.nacosGroupName, Collections.singletonList(this.serviceClusterName));
        for (Instance instance : allInstances) {
            if (!instance.getIp().equals(this.serviceIP) || instance.getPort() != this.servicePort) continue;
            logger.info("nacosNaming register already exists, " + this.commonLogMessage());
            this.registerStatus = false;
            return;
        }
        this.nacosNamingService.registerInstance(this.serviceName, this.nacosGroupName, this.serviceIP, this.servicePort, this.serviceClusterName);
        this.registerStatus = true;
        logger.info("nacosNaming register Service, " + this.commonLogMessage());
    }

    public void onStop(AppContext appContext) throws Throwable {
        if (this.registerStatus) {
            logger.info("nacosNaming deregister Service, " + this.commonLogMessage());
            this.nacosNamingService.deregisterInstance(this.serviceName, this.nacosGroupName, this.serviceIP, this.servicePort, this.serviceClusterName);
        }
    }

    protected String commonLogMessage() {
        return "serviceName=" + this.serviceName + ", groupName=" + this.nacosGroupName + ", ip=" + this.serviceIP + ", port=" + this.servicePort + ", clusterName=" + this.serviceClusterName;
    }
}

