/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.dal.providers.db;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.dal.ApiTypeEnum;
import net.hasor.dataway.dal.FieldDef;
import net.hasor.dataway.dal.QueryCondition;
import net.hasor.dataway.dal.providers.db.AbstractDal;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.utils.StringUtils;

public class InterfaceInfoDal
extends AbstractDal {
    private final String infoTableName;
    private static final Map<FieldDef, String> infoIndexColumn = new HashMap<FieldDef, String>(){
        {
            this.put(FieldDef.ID, "api_id");
            this.put(FieldDef.PATH, "api_path");
        }
    };

    public InterfaceInfoDal(JdbcTemplate jdbcTemplate, String dbType, String tableName) {
        super(jdbcTemplate, dbType);
        this.infoTableName = tableName;
    }

    @Override
    public String getTableName() {
        return this.infoTableName;
    }

    private static Map<FieldDef, String> mapToDef(Map<String, Object> entMap) {
        HashMap<FieldDef, String> dataMap = new HashMap<FieldDef, String>();
        dataMap.put(FieldDef.ID, String.valueOf(entMap.get("api_id")));
        dataMap.put(FieldDef.API_ID, String.valueOf(entMap.get("api_id")));
        dataMap.put(FieldDef.METHOD, String.valueOf(entMap.get("api_method")));
        dataMap.put(FieldDef.PATH, String.valueOf(entMap.get("api_path")));
        dataMap.put(FieldDef.STATUS, String.valueOf(entMap.get("api_status")));
        Object apiComment = entMap.get("api_comment");
        dataMap.put(FieldDef.COMMENT, apiComment != null ? apiComment.toString() : "");
        dataMap.put(FieldDef.TYPE, String.valueOf(entMap.get("api_type")));
        Object apiOption = entMap.get("api_option");
        dataMap.put(FieldDef.OPTION, apiOption != null ? apiOption.toString() : "{}");
        dataMap.put(FieldDef.CREATE_TIME, String.valueOf(entMap.get("api_create_time")));
        dataMap.put(FieldDef.GMT_TIME, String.valueOf(entMap.get("api_gmt_time")));
        if (entMap.containsKey("api_schema")) {
            JSONObject jsonObject = JSON.parseObject((String)entMap.get("api_schema").toString());
            JSONObject requestHeaderSchema = jsonObject.getJSONObject("requestHeader");
            JSONObject requestBodySchema = jsonObject.getJSONObject("requestBody");
            JSONObject responseHeaderSchema = jsonObject.getJSONObject("responseHeader");
            JSONObject responseBodySchema = jsonObject.getJSONObject("responseBody");
            if (jsonObject.containsKey((Object)"requestSchema") || jsonObject.containsKey((Object)"responseSchema")) {
                requestBodySchema = jsonObject.getJSONObject("requestSchema");
                responseBodySchema = jsonObject.getJSONObject("responseSchema");
            }
            dataMap.put(FieldDef.REQ_HEADER_SCHEMA, requestHeaderSchema != null ? requestHeaderSchema.toJSONString() : null);
            dataMap.put(FieldDef.REQ_BODY_SCHEMA, requestBodySchema != null ? requestBodySchema.toJSONString() : null);
            dataMap.put(FieldDef.RES_HEADER_SCHEMA, responseHeaderSchema != null ? responseHeaderSchema.toJSONString() : null);
            dataMap.put(FieldDef.RES_BODY_SCHEMA, responseBodySchema != null ? responseBodySchema.toJSONString() : null);
        }
        if (entMap.containsKey("api_sample")) {
            JSONObject sampleObject = JSON.parseObject((String)entMap.get("api_sample").toString());
            String requestHeader = sampleObject.getString("requestHeader");
            String requestBody = sampleObject.getString("requestBody");
            String responseHeader = sampleObject.getString("responseHeader");
            String responseBody = sampleObject.getString("responseBody");
            if (sampleObject.containsKey((Object)"headerData")) {
                requestHeader = sampleObject.getJSONArray("headerData").toJSONString();
            }
            dataMap.put(FieldDef.REQ_HEADER_SAMPLE, requestHeader == null ? "[]" : requestHeader);
            dataMap.put(FieldDef.REQ_BODY_SAMPLE, StringUtils.isBlank((String)requestBody) ? "{}" : requestBody);
            dataMap.put(FieldDef.RES_HEADER_SAMPLE, responseHeader == null ? "[]" : responseHeader);
            dataMap.put(FieldDef.RES_BODY_SAMPLE, StringUtils.isBlank((String)responseBody) ? "{}" : responseBody);
        }
        if (entMap.containsKey("api_script")) {
            String scriptOri;
            String scriptTarget = scriptOri = entMap.get("api_script").toString();
            ApiTypeEnum typeEnum = ApiTypeEnum.typeOf(dataMap.get((Object)FieldDef.TYPE));
            if (ApiTypeEnum.SQL == typeEnum) {
                String requestBodySample = (String)dataMap.get((Object)FieldDef.REQ_BODY_SAMPLE);
                JSONObject strRequestBody = JSON.parseObject((String)requestBodySample);
                strRequestBody = strRequestBody == null ? Collections.emptyMap() : strRequestBody;
                scriptTarget = DatawayUtils.evalCodeValueForSQL(scriptOri, (Map<String, Object>)strRequestBody);
            }
            dataMap.put(FieldDef.SCRIPT, scriptTarget);
            dataMap.put(FieldDef.SCRIPT_ORI, scriptOri);
        }
        return dataMap;
    }

    private static Map<String, Object> defToMap(Map<FieldDef, String> entMap) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.computeIfAbsent("api_id", s -> (String)entMap.get((Object)FieldDef.ID));
        dataMap.computeIfAbsent("api_method", s -> (String)entMap.get((Object)FieldDef.METHOD));
        dataMap.computeIfAbsent("api_path", s -> (String)entMap.get((Object)FieldDef.PATH));
        dataMap.computeIfAbsent("api_status", s -> (String)entMap.get((Object)FieldDef.STATUS));
        dataMap.computeIfAbsent("api_comment", s -> (String)entMap.get((Object)FieldDef.COMMENT));
        dataMap.computeIfAbsent("api_type", s -> (String)entMap.get((Object)FieldDef.TYPE));
        dataMap.computeIfAbsent("api_script", s -> (String)entMap.get((Object)FieldDef.SCRIPT_ORI));
        dataMap.computeIfAbsent("api_schema", s -> {
            StringBuilder schemaData = new StringBuilder();
            schemaData.append("{");
            if (entMap.get((Object)FieldDef.REQ_HEADER_SCHEMA) != null) {
                schemaData.append("\"requestHeader\":" + (String)entMap.get((Object)FieldDef.REQ_HEADER_SCHEMA) + ",");
            }
            if (entMap.get((Object)FieldDef.REQ_BODY_SCHEMA) != null) {
                schemaData.append("\"requestBody\":" + (String)entMap.get((Object)FieldDef.REQ_BODY_SCHEMA) + ",");
            }
            if (entMap.get((Object)FieldDef.RES_HEADER_SCHEMA) != null) {
                schemaData.append("\"responseHeader\":" + (String)entMap.get((Object)FieldDef.RES_HEADER_SCHEMA) + ",");
            }
            if (entMap.get((Object)FieldDef.RES_BODY_SCHEMA) != null) {
                schemaData.append("\"responseBody\":" + (String)entMap.get((Object)FieldDef.RES_BODY_SCHEMA) + ",");
            }
            if (schemaData.length() > 1) {
                schemaData.deleteCharAt(schemaData.length() - 1);
            }
            schemaData.append("}");
            return schemaData.toString();
        });
        dataMap.computeIfAbsent("api_sample", s -> {
            StringBuilder sampleData = new StringBuilder();
            sampleData.append("{");
            if (entMap.get((Object)FieldDef.REQ_HEADER_SAMPLE) != null) {
                sampleData.append("\"requestHeader\":" + JSON.toJSONString(entMap.get((Object)FieldDef.REQ_HEADER_SAMPLE)) + ",");
            }
            if (entMap.get((Object)FieldDef.REQ_BODY_SAMPLE) != null) {
                sampleData.append("\"requestBody\":" + JSON.toJSONString(entMap.get((Object)FieldDef.REQ_BODY_SAMPLE)) + ",");
            }
            if (entMap.get((Object)FieldDef.RES_HEADER_SAMPLE) != null) {
                sampleData.append("\"responseHeader\":" + JSON.toJSONString(entMap.get((Object)FieldDef.RES_HEADER_SAMPLE)) + ",");
            }
            if (entMap.get((Object)FieldDef.RES_BODY_SAMPLE) != null) {
                sampleData.append("\"responseBody\":" + JSON.toJSONString(entMap.get((Object)FieldDef.RES_BODY_SAMPLE)) + ",");
            }
            if (sampleData.length() > 1) {
                sampleData.deleteCharAt(sampleData.length() - 1);
            }
            sampleData.append("}");
            return sampleData.toString();
        });
        dataMap.computeIfAbsent("api_option", s -> (String)entMap.get((Object)FieldDef.OPTION));
        dataMap.computeIfAbsent("api_gmt_time", s -> (String)entMap.get((Object)FieldDef.GMT_TIME));
        dataMap.computeIfAbsent("api_create_time", s -> (String)entMap.get((Object)FieldDef.CREATE_TIME));
        return dataMap;
    }

    public Map<FieldDef, String> getObjectBy(FieldDef indexKey, String indexValue) throws SQLException {
        String indexField = infoIndexColumn.get((Object)indexKey);
        if (StringUtils.isBlank((String)indexField)) {
            throw new SQLException("table " + this.infoTableName + " not index " + indexKey.name());
        }
        String sqlQuery = "select * from " + this.infoTableName + " where " + indexField + " = ?";
        Map data = this.jdbcTemplate.queryForMap(sqlQuery, new Object[]{indexValue});
        return data != null ? InterfaceInfoDal.mapToDef(data) : null;
    }

    public List<Map<FieldDef, String>> listObjectBy(Map<QueryCondition, Object> conditions) throws SQLException {
        String sqlQuery = "select api_id,api_method,api_path,api_status,api_comment,api_type,api_create_time,api_gmt_time from " + this.infoTableName + " order by api_create_time asc";
        List mapList = this.jdbcTemplate.queryForList(sqlQuery);
        return mapList.parallelStream().map(InterfaceInfoDal::mapToDef).collect(Collectors.toList());
    }

    public boolean deleteObject(String id) throws SQLException {
        String sqlQuery = "delete from " + this.infoTableName + " where api_id = ?";
        return this.jdbcTemplate.executeUpdate(sqlQuery, new Object[]{id}) > 0;
    }

    public boolean updateObject(String id, Map<FieldDef, String> newData) throws SQLException {
        ArrayList<String> updateData = new ArrayList<String>();
        StringBuffer sqlBuffer = new StringBuffer();
        InterfaceInfoDal.defToMap(newData).forEach((key, value) -> {
            if (wontUpdateColumn.contains(key.toLowerCase())) {
                return;
            }
            sqlBuffer.append("," + key + " = ? ");
            updateData.add(this.fixString((String)key, value.toString()));
        });
        sqlBuffer.deleteCharAt(0);
        updateData.add(id);
        String sqlQuery = "update " + this.infoTableName + " set " + sqlBuffer.toString() + "where api_id = ?";
        return this.jdbcTemplate.executeUpdate(sqlQuery, updateData.toArray()) > 0;
    }

    public boolean createObject(Map<FieldDef, String> newData) throws SQLException {
        ArrayList insertData = new ArrayList();
        StringBuffer insertColumnBuffer = new StringBuffer();
        StringBuffer insertParamsBuffer = new StringBuffer();
        InterfaceInfoDal.defToMap(newData).forEach((key, value) -> {
            insertColumnBuffer.append("," + key);
            insertParamsBuffer.append(",?");
            insertData.add(this.fixString((String)key, value.toString()));
        });
        insertColumnBuffer.deleteCharAt(0);
        insertParamsBuffer.deleteCharAt(0);
        String sqlQuery = "insert into " + this.infoTableName + " (" + insertColumnBuffer.toString() + ") values (" + insertParamsBuffer.toString() + ")";
        return this.jdbcTemplate.executeUpdate(sqlQuery, insertData.toArray()) > 0;
    }
}

