/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.dal.providers.db;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.hasor.core.Singleton;
import net.hasor.dataway.dal.ApiStatusEnum;
import net.hasor.dataway.dal.FieldDef;
import net.hasor.dataway.dal.QueryCondition;
import net.hasor.dataway.dal.providers.db.AbstractDal;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.utils.StringUtils;

@Singleton
public class InterfaceReleaseDal
extends AbstractDal {
    private final String releaseTableName;
    protected static final Map<FieldDef, String> pubIndexColumn = new HashMap<FieldDef, String>(){
        {
            this.put(FieldDef.ID, "pub_id");
            this.put(FieldDef.API_ID, "pub_api_id");
            this.put(FieldDef.PATH, "pub_path");
        }
    };

    public InterfaceReleaseDal(JdbcTemplate jdbcTemplate, String dbType, String tableName) {
        super(jdbcTemplate, dbType);
        this.releaseTableName = tableName;
    }

    @Override
    public String getTableName() {
        return this.releaseTableName;
    }

    private static Map<FieldDef, String> mapToDef(Map<String, Object> entMap) {
        Object apiOption;
        HashMap<FieldDef, String> dataMap = new HashMap<FieldDef, String>();
        dataMap.put(FieldDef.ID, entMap.get("pub_id").toString());
        dataMap.put(FieldDef.API_ID, entMap.get("pub_api_id").toString());
        dataMap.put(FieldDef.METHOD, entMap.get("pub_method").toString());
        dataMap.put(FieldDef.PATH, entMap.get("pub_path").toString());
        dataMap.put(FieldDef.STATUS, entMap.get("pub_status").toString());
        if (entMap.containsKey("pub_comment")) {
            Object pubComment = entMap.get("pub_comment");
            dataMap.put(FieldDef.COMMENT, pubComment == null ? "" : pubComment.toString());
        }
        dataMap.put(FieldDef.TYPE, entMap.get("pub_type").toString());
        if (entMap.containsKey("pub_script")) {
            dataMap.put(FieldDef.SCRIPT, entMap.get("pub_script").toString());
        }
        if (entMap.containsKey("pub_script_ori")) {
            dataMap.put(FieldDef.SCRIPT_ORI, entMap.get("pub_script_ori").toString());
        }
        if (entMap.containsKey("pub_schema")) {
            JSONObject jsonObject = JSON.parseObject((String)entMap.get("pub_schema").toString());
            JSONObject requestHeaderSchema = jsonObject.getJSONObject("requestHeader");
            JSONObject requestBodySchema = jsonObject.getJSONObject("requestBody");
            JSONObject responseHeaderSchema = jsonObject.getJSONObject("responseHeader");
            JSONObject responseBodySchema = jsonObject.getJSONObject("responseBody");
            if (jsonObject.containsKey((Object)"requestSchema") || jsonObject.containsKey((Object)"responseSchema")) {
                requestBodySchema = jsonObject.getJSONObject("requestSchema");
                responseBodySchema = jsonObject.getJSONObject("responseSchema");
            }
            dataMap.put(FieldDef.REQ_HEADER_SCHEMA, requestHeaderSchema != null ? requestHeaderSchema.toJSONString() : null);
            dataMap.put(FieldDef.REQ_BODY_SCHEMA, requestBodySchema != null ? requestBodySchema.toJSONString() : null);
            dataMap.put(FieldDef.RES_HEADER_SCHEMA, responseHeaderSchema != null ? responseHeaderSchema.toJSONString() : null);
            dataMap.put(FieldDef.RES_BODY_SCHEMA, responseBodySchema != null ? responseBodySchema.toJSONString() : null);
        }
        if (entMap.containsKey("pub_sample")) {
            JSONObject sampleObject = JSON.parseObject((String)entMap.get("pub_sample").toString());
            String requestHeader = sampleObject.getString("requestHeader");
            String requestBody = sampleObject.getString("requestBody");
            String responseHeader = sampleObject.getString("responseHeader");
            String responseBody = sampleObject.getString("responseBody");
            if (sampleObject.containsKey((Object)"headerData")) {
                requestHeader = sampleObject.getJSONArray("headerData").toJSONString();
            }
            dataMap.put(FieldDef.REQ_HEADER_SAMPLE, requestHeader == null ? "[]" : requestHeader);
            dataMap.put(FieldDef.REQ_BODY_SAMPLE, StringUtils.isBlank((String)requestBody) ? "{}" : requestBody);
            dataMap.put(FieldDef.RES_HEADER_SAMPLE, responseHeader == null ? "[]" : responseHeader);
            dataMap.put(FieldDef.RES_BODY_SAMPLE, StringUtils.isBlank((String)responseBody) ? "{}" : responseBody);
        }
        dataMap.put(FieldDef.OPTION, (apiOption = entMap.get("pub_option")) != null ? apiOption.toString() : "{}");
        dataMap.put(FieldDef.RELEASE_TIME, entMap.get("pub_release_time").toString());
        return dataMap;
    }

    private static Map<String, Object> defToMap(Map<FieldDef, String> entMap) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.computeIfAbsent("pub_id", s -> (String)entMap.get((Object)FieldDef.ID));
        dataMap.computeIfAbsent("pub_api_id", s -> (String)entMap.get((Object)FieldDef.API_ID));
        dataMap.computeIfAbsent("pub_method", s -> (String)entMap.get((Object)FieldDef.METHOD));
        dataMap.computeIfAbsent("pub_path", s -> (String)entMap.get((Object)FieldDef.PATH));
        dataMap.computeIfAbsent("pub_status", s -> (String)entMap.get((Object)FieldDef.STATUS));
        dataMap.computeIfAbsent("pub_comment", s -> (String)entMap.get((Object)FieldDef.COMMENT));
        dataMap.computeIfAbsent("pub_type", s -> (String)entMap.get((Object)FieldDef.TYPE));
        dataMap.computeIfAbsent("pub_script", s -> (String)entMap.get((Object)FieldDef.SCRIPT));
        dataMap.computeIfAbsent("pub_script_ori", s -> (String)entMap.get((Object)FieldDef.SCRIPT_ORI));
        dataMap.computeIfAbsent("pub_schema", s -> {
            StringBuilder schemaData = new StringBuilder();
            schemaData.append("{");
            schemaData.append("\"requestHeader\":" + (String)entMap.get((Object)FieldDef.REQ_HEADER_SCHEMA) + ",");
            schemaData.append("\"requestBody\":" + (String)entMap.get((Object)FieldDef.REQ_BODY_SCHEMA) + ",");
            schemaData.append("\"responseHeader\":" + (String)entMap.get((Object)FieldDef.RES_HEADER_SCHEMA) + ",");
            schemaData.append("\"responseBody\":" + (String)entMap.get((Object)FieldDef.RES_BODY_SCHEMA));
            schemaData.append("}");
            return schemaData.toString();
        });
        dataMap.computeIfAbsent("pub_sample", s -> {
            StringBuffer sampleData = new StringBuffer();
            sampleData.append("{");
            sampleData.append("\"requestHeader\":" + JSON.toJSONString(entMap.get((Object)FieldDef.REQ_HEADER_SAMPLE)) + ",");
            sampleData.append("\"requestBody\":" + JSON.toJSONString(entMap.get((Object)FieldDef.REQ_BODY_SAMPLE)) + ",");
            sampleData.append("\"responseHeader\":" + JSON.toJSONString(entMap.get((Object)FieldDef.RES_HEADER_SAMPLE)) + ",");
            sampleData.append("\"responseBody\":" + JSON.toJSONString(entMap.get((Object)FieldDef.RES_BODY_SAMPLE)));
            sampleData.append("}");
            return sampleData.toString();
        });
        dataMap.computeIfAbsent("pub_option", s -> (String)entMap.get((Object)FieldDef.OPTION));
        dataMap.computeIfAbsent("pub_release_time", s -> (String)entMap.get((Object)FieldDef.RELEASE_TIME));
        return dataMap;
    }

    public Map<FieldDef, String> getObjectBy(FieldDef indexKey, String indexValue) throws SQLException {
        ArrayList<String> data;
        String sqlQuery;
        if (indexKey == FieldDef.PATH) {
            sqlQuery = "select pub_id,pub_api_id from " + this.releaseTableName + " where pub_status != ? and pub_path = ? order by pub_release_time desc";
            data = new ArrayList<String>();
            data.add(String.valueOf(ApiStatusEnum.Delete.typeNum()));
            data.add(indexValue);
            List tempList = this.jdbcTemplate.queryForList(sqlQuery, data.toArray());
            if (tempList == null || tempList.isEmpty()) {
                return null;
            }
            Map objectMap = (Map)tempList.get(0);
            indexValue = objectMap.get("pub_id").toString();
        }
        sqlQuery = "select * from " + this.releaseTableName + " where pub_status != ? and pub_id = ?";
        data = new ArrayList();
        data.add(String.valueOf(ApiStatusEnum.Delete.typeNum()));
        data.add(indexValue);
        Map objectMap = this.jdbcTemplate.queryForMap(sqlQuery, data.toArray());
        return objectMap != null ? InterfaceReleaseDal.mapToDef(objectMap) : null;
    }

    public List<Map<FieldDef, String>> listObjectBy(Map<QueryCondition, Object> conditions) throws SQLException {
        String releaseList = "select pub_id,pub_api_id,pub_method,pub_path,pub_status,pub_type,pub_comment,pub_schema,pub_release_time from " + this.releaseTableName + " ";
        ArrayList<String> data = new ArrayList<String>();
        if (conditions.containsKey((Object)QueryCondition.ApiId)) {
            releaseList = releaseList + "where pub_status != ? and pub_api_id = ? order by pub_release_time desc";
            data.add(String.valueOf(ApiStatusEnum.Delete.typeNum()));
            data.add(conditions.get((Object)QueryCondition.ApiId).toString());
        } else {
            releaseList = releaseList + "where pub_status != ? order by pub_release_time desc";
            data.add(String.valueOf(ApiStatusEnum.Delete.typeNum()));
        }
        List mapList = this.jdbcTemplate.queryForList(releaseList, data.toArray());
        return mapList.parallelStream().map(InterfaceReleaseDal::mapToDef).collect(Collectors.toList());
    }

    public boolean deleteObject(String id) throws SQLException {
        throw new SQLException("table " + this.releaseTableName + " cannot be modified.");
    }

    public boolean updateObject(String id, Map<FieldDef, String> newData) throws SQLException {
        ArrayList<String> updateData = new ArrayList<String>();
        StringBuffer sqlBuffer = new StringBuffer();
        InterfaceReleaseDal.defToMap(newData).forEach((key, value) -> {
            if (wontUpdateColumn.contains(key.toLowerCase())) {
                return;
            }
            sqlBuffer.append("," + key + " = ? ");
            updateData.add(this.fixString((String)key, value.toString()));
        });
        sqlBuffer.deleteCharAt(0);
        updateData.add(id);
        String sqlQuery = "update " + this.releaseTableName + " set " + sqlBuffer.toString() + "where pub_id = ?";
        return this.jdbcTemplate.executeUpdate(sqlQuery, updateData.toArray()) > 0;
    }

    public boolean createObject(Map<FieldDef, String> newData) throws SQLException {
        ArrayList insertData = new ArrayList();
        StringBuffer insertColumnBuffer = new StringBuffer();
        StringBuffer insertParamsBuffer = new StringBuffer();
        InterfaceReleaseDal.defToMap(newData).forEach((key, value) -> {
            insertColumnBuffer.append("," + key);
            insertParamsBuffer.append(",?");
            insertData.add(this.fixString((String)key, value.toString()));
        });
        insertColumnBuffer.deleteCharAt(0);
        insertParamsBuffer.deleteCharAt(0);
        String sqlQuery = "insert into " + this.releaseTableName + " (" + insertColumnBuffer.toString() + ") values (" + insertParamsBuffer.toString() + ")";
        return this.jdbcTemplate.executeUpdate(sqlQuery, insertData.toArray()) > 0;
    }
}

