/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.dal.providers.nacos;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import net.hasor.core.AppContext;
import net.hasor.core.Init;
import net.hasor.core.Inject;
import net.hasor.core.InjectSettings;
import net.hasor.core.Singleton;
import net.hasor.dataway.dal.ApiDataAccessLayer;
import net.hasor.dataway.dal.ApiStatusEnum;
import net.hasor.dataway.dal.EntityDef;
import net.hasor.dataway.dal.FieldDef;
import net.hasor.dataway.dal.QueryCondition;
import net.hasor.dataway.dal.providers.nacos.ApiJson;
import net.hasor.dataway.dal.providers.nacos.DataEnt;
import net.hasor.dataway.dal.providers.nacos.NacosListener;
import net.hasor.dataway.dal.providers.nacos.NacosUtils;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.NameThreadFactory;
import net.hasor.utils.StringUtils;
import net.hasor.utils.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class NacosApiDataAccessLayer
implements ApiDataAccessLayer {
    private static final int INDEX_MAX_SIZE = 101376;
    private static final String INDEX_PREFIX = "INDEX_DIRECTORY_";
    private static final String INDEX_CHANGE_MONITOR = "INDEX_MONITOR";
    protected static Logger logger = LoggerFactory.getLogger(NacosApiDataAccessLayer.class);
    @InjectSettings(value="hasor.dataway.settings.dal_nacos_addr")
    private String nacosServerAddr;
    @InjectSettings(value="hasor.dataway.settings.dal_nacos_group", defaultValue="HASOR_DATAWAY")
    private String groupName;
    private ConfigService configService;
    private ScheduledExecutorService executorService;
    @Inject
    private AppContext appContext;
    @InjectSettings(value="hasor.dataway.settings.dal_nacos_api_max_size", defaultValue="4000")
    private int apiMaxSize;
    private final Map<String, DataEnt> dataCache = new ConcurrentHashMap<String, DataEnt>();
    private final Map<String, String> releaseMapping = new ConcurrentHashMap<String, String>();
    private long lastRefreshTime = 0L;
    private Thread asyncTaskWorker;
    private final Queue<ApiJson> asyncTask = new LinkedBlockingDeque<ApiJson>();

    @Override
    public Map<FieldDef, String> getObjectBy(EntityDef objectType, FieldDef indexKey, String index) {
        String entityID = index;
        if (FieldDef.PATH == indexKey) {
            entityID = this.objectIdByPath(objectType, index);
        }
        if (entityID == null) {
            return null;
        }
        if (this.dataCache.containsKey(entityID)) {
            DataEnt dataEnt = this.dataCache.get(entityID);
            return dataEnt.getDataEnt();
        }
        return null;
    }

    private String objectIdByPath(EntityDef objectType, String index) {
        String entityID = index;
        if (EntityDef.RELEASE == objectType) {
            if (this.releaseMapping.containsKey(entityID)) {
                entityID = this.releaseMapping.get(entityID);
            } else {
                Map entity = this.listObjectBy(objectType, Collections.emptyMap()).stream().filter(entData -> {
                    boolean matched = ((String)entData.get((Object)FieldDef.PATH)).equals(index);
                    if (!matched) {
                        return false;
                    }
                    ApiStatusEnum statusEnum = ApiStatusEnum.typeOf(entData.get((Object)FieldDef.STATUS));
                    return ApiStatusEnum.Published == statusEnum;
                }).findFirst().orElse(null);
                if (entity == null) {
                    return null;
                }
                entityID = (String)entity.get((Object)FieldDef.ID);
                this.releaseMapping.put(index, entityID);
            }
        } else {
            entityID = NacosApiDataAccessLayer.evalId(objectType, entityID);
        }
        return entityID;
    }

    @Override
    public List<Map<FieldDef, String>> listObjectBy(EntityDef objectType, Map<QueryCondition, Object> conditions) {
        if (EntityDef.INFO == objectType) {
            return this.dataCache.values().stream().filter(entData -> entData.getId().startsWith("i_")).sorted((o1, o2) -> {
                long t1 = Long.parseLong(o1.getDataEnt().get((Object)FieldDef.CREATE_TIME));
                long t2 = Long.parseLong(o2.getDataEnt().get((Object)FieldDef.CREATE_TIME));
                return Long.compare(t1, t2);
            }).map(DataEnt::getDataEnt).collect(Collectors.toList());
        }
        String apiId = (String)conditions.get((Object)QueryCondition.ApiId);
        return this.dataCache.values().stream().filter(entData -> {
            boolean isRelease = entData.getId().startsWith("r_");
            String entApiId = entData.getDataEnt().get((Object)FieldDef.API_ID);
            boolean idMatched = StringUtils.equalsIgnoreCase((String)apiId, (String)entApiId) || StringUtils.isBlank((String)apiId);
            return idMatched && isRelease;
        }).sorted((o1, o2) -> {
            long t1 = Long.parseLong(o1.getDataEnt().get((Object)FieldDef.RELEASE_TIME));
            long t2 = Long.parseLong(o2.getDataEnt().get((Object)FieldDef.RELEASE_TIME));
            return -Long.compare(t1, t2);
        }).map(DataEnt::getDataEnt).collect(Collectors.toList());
    }

    @Override
    public String generateId(EntityDef objectType, String apiPath) {
        return NacosApiDataAccessLayer.evalId(objectType, apiPath);
    }

    private static String evalId(EntityDef objectType, String oriId) {
        try {
            MessageDigest mdTemp = MessageDigest.getInstance("SHA1");
            mdTemp.update(oriId.getBytes());
            byte[] digest = mdTemp.digest();
            oriId = new BigInteger(digest).abs().toString(24);
        }
        catch (NoSuchAlgorithmException e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
        return (EntityDef.INFO == objectType ? "i_" : "r_") + oriId.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteObject(EntityDef objectType, String id) {
        try {
            this.doRemove(id);
            DataEnt dataEnt = this.dataCache.get(id);
            if (objectType == EntityDef.RELEASE) {
                this.releaseMapping.remove(dataEnt.getDataEnt().get((Object)FieldDef.PATH));
            }
            this.dataCache.remove(id);
            logger.info(String.format("nacosDal loadData '%s' removed.", id));
            boolean bl = true;
            return bl;
        }
        finally {
            this.updateDirectory();
        }
    }

    @Override
    public boolean updateObject(EntityDef objectType, String id, Map<FieldDef, String> newData) {
        return this.createOrUpdate(id, objectType, newData);
    }

    @Override
    public boolean createObject(EntityDef objectType, Map<FieldDef, String> newData) {
        return this.createOrUpdate(newData.get((Object)FieldDef.ID), objectType, newData);
    }

    private boolean createOrUpdate(String id, EntityDef entityDef, Map<FieldDef, String> newData) {
        newData = new HashMap<FieldDef, String>(newData);
        DataEnt oldEnt = null;
        DataEnt newEnt = new DataEnt();
        if (this.dataCache.containsKey(id)) {
            oldEnt = this.dataCache.get(id);
        }
        newEnt.setId(id);
        newEnt.setPath(newData.get((Object)FieldDef.PATH));
        newEnt.setTime(System.currentTimeMillis());
        newEnt.setDataEnt(newData);
        ApiStatusEnum statusEnum = ApiStatusEnum.typeOf(newData.get((Object)FieldDef.STATUS));
        if (statusEnum == ApiStatusEnum.Delete) {
            return this.deleteObject(entityDef, id);
        }
        if (!this.dataCache.containsKey(id) && this.dataCache.size() >= this.apiMaxSize) {
            String message = "nacosDal dataCache out of size (" + this.apiMaxSize + ")";
            logger.error(message);
            throw new IllegalStateException(message);
        }
        this.doSave(id, JSON.toJSONString(NacosUtils.defToMap(newData)));
        this.dataCache.put(id, newEnt);
        this.updateDirectory();
        logger.info("nacosDal dataCache '" + id + "' added.");
        return true;
    }

    protected synchronized void updateDirectory() {
        TreeSet<String> keys = new TreeSet<String>(String::compareTo);
        keys.addAll(this.dataCache.keySet());
        ArrayList<StringBuilder> dataList = new ArrayList<StringBuilder>();
        dataList.add(new StringBuilder());
        keys.forEach(key -> {
            DataEnt dataEnt = this.dataCache.get(key);
            StringBuilder newItem = new StringBuilder();
            newItem.append((String)key);
            newItem.append(",");
            newItem.append(dataEnt.getTime());
            newItem.append(",");
            newItem.append(dataEnt.getPath());
            newItem.append("\n");
            StringBuilder lastLine = (StringBuilder)dataList.get(dataList.size() - 1);
            if (lastLine.length() + newItem.length() > 101376) {
                lastLine = new StringBuilder();
                dataList.add(lastLine);
            }
            lastLine.append((CharSequence)newItem);
        });
        ((StringBuilder)dataList.get(dataList.size() - 1)).append("END");
        for (int i = 0; i < dataList.size(); ++i) {
            String pushData = ((StringBuilder)dataList.get(i)).toString();
            this.doSave(INDEX_PREFIX + i, pushData);
        }
        this.lastRefreshTime = System.currentTimeMillis();
        logger.info("nacosDal update Monitor timestamp -> " + this.lastRefreshTime);
        this.doSave(INDEX_CHANGE_MONITOR, String.valueOf(this.lastRefreshTime));
    }

    @Init
    public void init() throws NacosException {
        if (this.apiMaxSize <= 0) {
            throw new IllegalArgumentException("apiMaxSize must be > 0.");
        }
        if (StringUtils.isBlank((String)this.groupName)) {
            throw new IllegalArgumentException("config nacos group is missing.");
        }
        if (StringUtils.isBlank((String)this.nacosServerAddr)) {
            throw new IllegalArgumentException("config nacos server addr is missing.");
        }
        this.configService = (ConfigService)this.appContext.getInstance(ConfigService.class);
        if (this.configService == null) {
            Properties properties = new Properties();
            properties.put("serverAddr", this.nacosServerAddr);
            this.configService = NacosFactory.createConfigService((Properties)properties);
            logger.info("nacosDal init ConfigService, serverAddr = " + this.nacosServerAddr + ", groupName=" + this.groupName);
        } else {
            logger.info("nacosDal Containers provide ConfigService.");
        }
        NameThreadFactory threadFactory = new NameThreadFactory("NacosThread-%s", this.appContext.getClassLoader());
        this.executorService = Executors.newScheduledThreadPool(3, (ThreadFactory)threadFactory);
        ThreadPoolExecutor threadPool = (ThreadPoolExecutor)((Object)this.executorService);
        threadPool.setCorePoolSize(3);
        threadPool.setMaximumPoolSize(3);
        this.configService.addListener(INDEX_CHANGE_MONITOR, this.groupName, (Listener)new NacosListener(this.executorService){

            public void receiveConfigInfo(String configInfo) {
                long lastTime = NacosApiDataAccessLayer.this.initDirectory(configInfo);
                NacosApiDataAccessLayer.this.refreshDirectory(lastTime);
            }
        });
        long lastTime = this.initDirectory(this.doLoad(INDEX_CHANGE_MONITOR));
        this.refreshDirectory(lastTime);
        this.asyncTaskWorker = new Thread(this::asyncLoadDataToCache);
        this.asyncTaskWorker.setDaemon(true);
        this.asyncTaskWorker.setName("NacosAsyncTaskWorker");
        this.asyncTaskWorker.start();
    }

    private long initDirectory(String configInfo) {
        if (StringUtils.isBlank((String)configInfo)) {
            configInfo = String.valueOf(System.currentTimeMillis());
            logger.info("nacosDal init Monitor timestamp -> " + configInfo);
            this.doSave(INDEX_CHANGE_MONITOR, configInfo);
        }
        return Long.parseLong(configInfo);
    }

    private void refreshDirectory(long lastRefreshTime) {
        if (this.lastRefreshTime >= lastRefreshTime) {
            logger.info("nacosDal local is fresh. (localTag=" + this.lastRefreshTime + ", remoteTag=" + lastRefreshTime + ")");
            return;
        }
        HashMap<String, ApiJson> allApis = new HashMap<String, ApiJson>();
        int index = 0;
        boolean fetchData = true;
        while (fetchData) {
            String dataId = INDEX_PREFIX + index;
            List entryList = null;
            try {
                String dataBody = this.doLoad(dataId);
                if (StringUtils.isBlank((String)dataBody)) {
                    logger.info("nacosDal refreshDirectory fetch end at " + dataId + " ,data is empty.");
                    fetchData = false;
                    break;
                }
                entryList = IOUtils.readLines((Reader)new StringReader(dataBody));
                logger.info("nacosDal refreshDirectory fetch data at " + dataId);
            }
            catch (Exception e) {
                logger.info("nacosDal refreshDirectory fetch end at " + dataId + " ,error -> " + e.getMessage());
                fetchData = false;
                break;
            }
            for (String entryItem : entryList) {
                Object[] entryItemSplit;
                if ("end".equalsIgnoreCase(entryItem = entryItem.trim())) {
                    logger.info("nacosDal refreshDirectory fetch end at " + dataId + " ,encounter end.");
                    fetchData = false;
                    break;
                }
                if (StringUtils.isBlank((String)entryItem) || (entryItemSplit = entryItem.split(",")).length < 3) continue;
                String entryDat = StringUtils.join((Object[])entryItemSplit, (String)",", (int)1, (int)entryItemSplit.length);
                int timestampEndIndex = entryDat.indexOf(",");
                Object apiTimestamp = entryItemSplit[1];
                String apiData = entryDat.substring(timestampEndIndex + 1);
                ApiJson apiJson = new ApiJson();
                apiJson.setId(((String)entryItemSplit[0]).trim());
                apiJson.setTime(Long.parseLong((String)apiTimestamp));
                apiJson.setPath(apiData);
                ApiJson local = (ApiJson)allApis.get(apiJson.getId());
                if (local != null && local.getTime() >= apiJson.getTime()) continue;
                allApis.put(apiJson.getId(), apiJson);
            }
            ++index;
        }
        logger.info("nacosDal refreshDirectory api total -> " + allApis.size());
        ArrayList<DataEnt> toRemove = new ArrayList<DataEnt>();
        this.dataCache.forEach((key, ent) -> {
            if (!allApis.containsKey(key)) {
                toRemove.add((DataEnt)ent);
            }
        });
        toRemove.forEach(ent -> {
            this.dataCache.remove(ent.getId());
            this.releaseMapping.remove(ent.getPath());
        });
        allApis.forEach((key, ent) -> {
            if (!this.dataCache.containsKey(key)) {
                this.asyncTask.offer((ApiJson)ent);
            }
        });
        this.lastRefreshTime = lastRefreshTime;
    }

    private void asyncLoadDataToCache() {
        while (true) {
            try {
                while (true) {
                    String config;
                    if (this.asyncTask.isEmpty()) {
                        Thread.sleep(300L);
                        continue;
                    }
                    ApiJson apiJson = this.asyncTask.peek();
                    if (apiJson == null || StringUtils.isBlank((String)(config = this.doLoad(apiJson.getId())))) continue;
                    Map<FieldDef, String> dataMap = NacosUtils.mapToDef((Map<String, Object>)JSON.parseObject((String)config));
                    if (dataMap == null || ApiStatusEnum.Delete == ApiStatusEnum.typeOf(dataMap.get((Object)FieldDef.STATUS))) {
                        this.dataCache.remove(apiJson.getId());
                        this.releaseMapping.remove(apiJson.getPath());
                        logger.info(String.format("nacosDal loadData '%s' is delete, ignore.", apiJson.getId()));
                        continue;
                    }
                    DataEnt ent = new DataEnt();
                    String apiId = dataMap.get((Object)FieldDef.ID);
                    ent.setId(apiId);
                    ent.setPath(dataMap.get((Object)FieldDef.PATH));
                    ent.setDataEnt(dataMap);
                    ent.setTime(apiJson.getTime());
                    this.dataCache.put(apiId, ent);
                    if (apiId.startsWith("r_")) {
                        this.releaseMapping.put(ent.getPath(), ent.getId());
                    }
                    logger.info(String.format("nacosDal loadData '%s' done.", apiId));
                    this.asyncTask.poll();
                }
            }
            catch (Exception e) {
                logger.error("nacosDal asyncLoadDataToCacheWork -> " + e.getMessage(), (Throwable)e);
                continue;
            }
            break;
        }
    }

    protected String doLoad(String configId) throws NacosException {
        return NacosUtils.doLoad(this.configService, this.groupName, configId);
    }

    protected void doSave(String configId, String configData) {
        NacosUtils.doSave(this.configService, this.groupName, configId, configData);
    }

    protected void doRemove(String configId) {
        NacosUtils.doRemove(this.configService, this.groupName, configId);
    }
}

