/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.dal.providers.nacos;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.HashMap;
import java.util.Map;
import net.hasor.dataway.dal.FieldDef;
import net.hasor.utils.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NacosUtils {
    private static Logger logger = LoggerFactory.getLogger(NacosUtils.class);

    NacosUtils() {
    }

    public static Map<FieldDef, String> mapToDef(Map<String, Object> entMap) {
        if (entMap == null) {
            return null;
        }
        HashMap<FieldDef, String> dataMap = new HashMap<FieldDef, String>();
        entMap.forEach((key, value) -> {
            for (FieldDef def : FieldDef.values()) {
                if (!def.name().equalsIgnoreCase((String)key)) continue;
                dataMap.put(def, value == null ? "" : value.toString());
            }
        });
        return dataMap;
    }

    public static Map<String, Object> defToMap(Map<FieldDef, String> entMap) {
        if (entMap == null) {
            return null;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        entMap.forEach((key, value) -> {
            if (value == null) {
                dataMap.put(key.name().toUpperCase(), "");
            } else {
                dataMap.put(key.name().toUpperCase(), value);
            }
        });
        return dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doLoad(ConfigService configService, String groupName, String configId) throws NacosException {
        int tryTimes = 0;
        while (true) {
            try {
                String string = configService.getConfig(configId, groupName, 3000L);
                return string;
            }
            catch (NacosException e) {
                if (tryTimes > 0) {
                    logger.error(String.format("nacos loadData '%s' failed. tryTimes %s ,errorMessage=" + e.getMessage(), configId, tryTimes));
                } else {
                    logger.error(String.format("nacos loadData '%s' failed, errorMessage=" + e.getMessage(), configId));
                }
                if (tryTimes < 3) continue;
                throw e;
            }
            finally {
                ++tryTimes;
                continue;
            }
            break;
        }
    }

    public static boolean doSave(ConfigService configService, String groupName, String configId, String configData) {
        try {
            return configService.publishConfig(configId, groupName, configData);
        }
        catch (Exception e1) {
            try {
                return configService.publishConfig(configId, groupName, configData);
            }
            catch (NacosException e2) {
                try {
                    return configService.publishConfig(configId, groupName, configData);
                }
                catch (NacosException e3) {
                    throw ExceptionUtils.toRuntimeException((Throwable)e3);
                }
            }
        }
    }

    public static boolean doRemove(ConfigService configService, String groupName, String configId) {
        try {
            return configService.removeConfig(configId, groupName);
        }
        catch (Exception e1) {
            try {
                return configService.removeConfig(configId, groupName);
            }
            catch (NacosException e2) {
                try {
                    return configService.removeConfig(configId, groupName);
                }
                catch (NacosException e3) {
                    throw ExceptionUtils.toRuntimeException((Throwable)e3);
                }
            }
        }
    }
}

