/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.service;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.hasor.core.Inject;
import net.hasor.core.Singleton;
import net.hasor.core.spi.SpiTrigger;
import net.hasor.dataql.DataQL;
import net.hasor.dataql.Query;
import net.hasor.dataql.QueryResult;
import net.hasor.dataql.compiler.qil.QIL;
import net.hasor.dataql.domain.DataModel;
import net.hasor.dataql.domain.DomainHelper;
import net.hasor.dataql.runtime.ThrowRuntimeException;
import net.hasor.dataql.runtime.mem.ExitType;
import net.hasor.dataway.authorization.PermissionType;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.config.LoggerUtils;
import net.hasor.dataway.service.QueryResultInfo;
import net.hasor.dataway.service.QueryScriptBuild;
import net.hasor.dataway.spi.ApiInfo;
import net.hasor.dataway.spi.AuthorizationChainSpi;
import net.hasor.dataway.spi.CompilerSpiListener;
import net.hasor.dataway.spi.PreExecuteChainSpi;
import net.hasor.dataway.spi.ResultProcessChainSpi;
import net.hasor.dataway.spi.StatusMessageException;
import net.hasor.utils.StringUtils;
import net.hasor.utils.future.BasicFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ApiCallService {
    protected static Logger logger = LoggerFactory.getLogger(ApiCallService.class);
    @Inject
    private SpiTrigger spiTrigger;
    @Inject
    private DataQL executeDataQL;

    public Object doCallWithoutError(ApiInfo apiInfo, QueryScriptBuild scriptBuild) throws Throwable {
        return this._doCall(apiInfo, scriptBuild, false);
    }

    public Object doCall(ApiInfo apiInfo, QueryScriptBuild scriptBuild) throws Throwable {
        return this._doCall(apiInfo, scriptBuild, true);
    }

    private Object _doCall(ApiInfo apiInfo, QueryScriptBuild scriptBuild, boolean needThrow) throws Throwable {
        LoggerUtils loggerUtils = LoggerUtils.create();
        loggerUtils.addLog("apiMethod", apiInfo.getMethod());
        loggerUtils.addLog("apiPath", apiInfo.getApiPath());
        Map<String, Object> parameterMap = apiInfo.getParameterMap();
        if (parameterMap != null) {
            loggerUtils.addLog("paramRootKeys", parameterMap.keySet());
        } else {
            loggerUtils.addLog("paramRootKeys", "empty.");
        }
        BasicFuture newResult = new BasicFuture();
        QueryResult execute = null;
        try {
            Boolean checkResult;
            if (this.spiTrigger.hasSpi(AuthorizationChainSpi.class) && ((checkResult = (Boolean)this.spiTrigger.chainSpi(AuthorizationChainSpi.class, (listener, lastResult) -> listener.doCheck(PermissionType.ApiExecute, apiInfo, (boolean)lastResult), (Object)true)) == null || !checkResult.booleanValue())) {
                throw new StatusMessageException(401, "no permission of api " + apiInfo.getApiPath());
            }
            if (this.spiTrigger.hasSpi(PreExecuteChainSpi.class)) {
                this.spiTrigger.chainSpi(PreExecuteChainSpi.class, (listener, lastResult) -> {
                    if (!newResult.isDone()) {
                        listener.preExecute(apiInfo, (BasicFuture<Object>)newResult);
                    }
                    return lastResult;
                });
            }
            if (newResult.isDone()) {
                Object data = newResult.get();
                execute = data instanceof QueryResult ? (QueryResult)data : QueryResultInfo.of(ExitType.Return, 0, DomainHelper.convertTo((Object)data), DatawayUtils.currentLostTime());
            } else {
                String scriptBody;
                QIL compiler;
                String wrapParameterName = DatawayUtils.wrapParameterName(apiInfo.getOptionMap());
                if (StringUtils.isNotBlank((String)wrapParameterName)) {
                    HashMap<String, Object> tmpParameterMap = new HashMap<String, Object>();
                    tmpParameterMap.put(wrapParameterName, parameterMap);
                    parameterMap = tmpParameterMap;
                }
                if ((compiler = (QIL)this.spiTrigger.notifySpi(CompilerSpiListener.class, (arg_0, arg_1) -> this.lambda$_doCall$2(apiInfo, scriptBody = scriptBuild.buildScript(parameterMap), arg_0, arg_1), null)) == null) {
                    compiler = CompilerSpiListener.DEFAULT.compiler(apiInfo, scriptBody, this.executeDataQL);
                }
                loggerUtils.addLog("compilerTime", DatawayUtils.currentLostTime());
                loggerUtils.addLog("prepareHint", apiInfo.getPrepareHint());
                Query query = this.executeDataQL.createQuery(compiler);
                if (apiInfo.getPrepareHint() != null) {
                    apiInfo.getPrepareHint().forEach((hint, value) -> {
                        if (value == null) {
                            query.setHint(hint, (String)null);
                        } else if (value instanceof Boolean) {
                            query.setHint(hint, ((Boolean)value).booleanValue());
                        } else if (value instanceof Number) {
                            query.setHint(hint, (Number)value);
                        } else {
                            query.setHint(hint, value.toString());
                        }
                    });
                }
                execute = query.execute(parameterMap);
            }
            loggerUtils.addLog("executionTime", execute.executionTime());
            loggerUtils.addLog("lifeCycleTime", DatawayUtils.currentLostTime());
            loggerUtils.addLog("code", execute.getCode());
            logger.info("requestSuccess - " + loggerUtils.toJson());
        }
        catch (Throwable e) {
            logger.error("requestFailed - " + loggerUtils.logException(e).toJson());
            return this.doError(needThrow, newResult.isDone(), e, apiInfo, loggerUtils);
        }
        try {
            Object resultData = execute.getData();
            if (this.spiTrigger.hasSpi(ResultProcessChainSpi.class)) {
                resultData = this.spiTrigger.chainSpi(ResultProcessChainSpi.class, (listener, lastResult) -> {
                    if (lastResult instanceof DataModel) {
                        lastResult = ((DataModel)lastResult).unwrap();
                    }
                    return listener.callAfter(newResult.isDone(), apiInfo, lastResult);
                }, resultData);
            }
            return DatawayUtils.queryResultToResultWithSpecialValue(apiInfo.getOptionMap(), execute, resultData).getResult();
        }
        catch (Throwable e) {
            logger.error("requestFailed - " + loggerUtils.logException(e).toJson());
            return this.doError(needThrow, newResult.isDone(), e, apiInfo, loggerUtils);
        }
    }

    private Object doError(boolean needThrow, boolean isFormPre, Throwable e, ApiInfo apiInfo, LoggerUtils loggerUtils) throws Throwable {
        Object value = null;
        if (e instanceof ExecutionException) {
            e = e.getCause();
        }
        value = e instanceof ThrowRuntimeException ? ((ThrowRuntimeException)e).getResult().unwrap() : e.getMessage();
        logger.error("requestFailed - " + loggerUtils.logException(e).toJson());
        if (this.spiTrigger.hasSpi(ResultProcessChainSpi.class)) {
            try {
                Throwable finalE = e;
                value = this.spiTrigger.chainSpi(ResultProcessChainSpi.class, (listener, lastResult) -> listener.callError(isFormPre, apiInfo, finalE), value);
            }
            catch (Throwable ee) {
                logger.error(ee.getMessage(), ee);
                e = ee;
            }
        } else {
            logger.error(e.getMessage(), e);
        }
        if (needThrow) {
            throw e;
        }
        return DatawayUtils.exceptionToResultWithSpecialValue(apiInfo.getOptionMap(), e, value).getResult();
    }

    private /* synthetic */ QIL lambda$_doCall$2(ApiInfo apiInfo, String scriptBody, CompilerSpiListener listener, QIL lastResult) throws Throwable {
        return listener.compiler(apiInfo, scriptBody, this.executeDataQL);
    }
}

