/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.service;

import java.util.Map;
import net.hasor.core.Inject;
import net.hasor.core.InjectSettings;
import net.hasor.core.Singleton;
import net.hasor.dataway.dal.ApiDataAccessLayer;
import net.hasor.dataway.dal.EntityDef;
import net.hasor.dataway.dal.FieldDef;
import net.hasor.utils.StringUtils;

@Singleton
public class CheckService {
    @InjectSettings(value="hasor.dataway.baseApiUrl")
    private String apiUrl;
    @Inject
    private ApiDataAccessLayer dataAccessLayer;

    public void checkApi(String apiPath) {
        if (StringUtils.isBlank((String)this.apiUrl)) {
            throw new IllegalArgumentException("The API path is empty.");
        }
        if (!apiPath.startsWith(this.apiUrl)) {
            throw new IllegalArgumentException("The API prefix must be " + this.apiUrl);
        }
        if (!apiPath.matches("[\\$\\(\\)\\*\\+\\-\\.!',/:;=@_~0-9a-zA-Z]+")) {
            throw new IllegalArgumentException("Allowed characters\uff1a !  $  '  (  )  *  +  ,  -  .  /  :  ;  =  @  _  ~  0-9  a-z  A-Z");
        }
        Map<FieldDef, String> object = this.dataAccessLayer.getObjectBy(EntityDef.INFO, FieldDef.PATH, apiPath);
        if (object != null) {
            throw new IllegalArgumentException("this API path has been used.");
        }
    }
}

