/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.InjectSettings;
import net.hasor.core.Singleton;
import net.hasor.dataway.DatawayApi;
import net.hasor.utils.StringUtils;
import net.hasor.utils.convert.ConverterUtils;
import net.hasor.web.Invoker;

@Singleton
public class CrossDomainService {
    @InjectSettings(value="hasor.dataway.globalConfig.enableCrossDomain")
    private boolean enableCrossDomain;

    public void configureCross(DatawayApi datawayApi, Invoker invoker) {
        Object crossDomainVal = datawayApi.getOptionMap().get("enableCrossDomain");
        boolean enableCrossDomainOnlyApi = crossDomainVal == null || StringUtils.isBlank((String)crossDomainVal.toString()) ? this.enableCrossDomain : (Boolean)ConverterUtils.convert(Boolean.TYPE, (Object)crossDomainVal);
        if (!enableCrossDomainOnlyApi) {
            return;
        }
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        HttpServletResponse httpResponse = invoker.getHttpResponse();
        String originString = httpRequest.getHeader("Origin");
        if (StringUtils.isNotBlank((String)originString)) {
            httpResponse.setHeader("Access-Control-Allow-Origin", originString);
            httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
        } else {
            httpResponse.setHeader("Access-Control-Allow-Origin", "*");
        }
        httpResponse.addHeader("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT, OPTIONS");
        httpResponse.addHeader("Access-Control-Allow-Headers", StringUtils.join((Object[])new String[]{"Origin", "X-Requested-With", "Content-Type", "X-InterfaceUI-Info", "Accept", "Accept-Encoding", "Accept-Language", "Host", "Referer", "Connection", "User-Agent", "Authorization", "authorization", "connection", "sw-useragent", "sw-version"}, (String)","));
        httpResponse.addHeader("Access-Control-Expose-Headers", "X-InterfaceUI-ContextType");
        httpResponse.addHeader("Access-Control-Max-Age", "3600");
    }
}

