/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hasor.core.Inject;
import net.hasor.core.Singleton;
import net.hasor.core.spi.SpiTrigger;
import net.hasor.dataql.Hints;
import net.hasor.dataql.runtime.HintsSet;
import net.hasor.dataway.DatawayApi;
import net.hasor.dataway.DatawayService;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.dal.ApiDataAccessLayer;
import net.hasor.dataway.dal.ApiStatusEnum;
import net.hasor.dataway.dal.EntityDef;
import net.hasor.dataway.dal.FieldDef;
import net.hasor.dataway.dal.QueryCondition;
import net.hasor.dataway.service.ApiCallService;
import net.hasor.dataway.spi.ApiInfo;
import net.hasor.dataway.spi.CallSource;

@Singleton
public class DatawayServiceImpl
implements DatawayService {
    @Inject
    private ApiCallService callService;
    @Inject
    private ApiDataAccessLayer dataAccessLayer;
    @Inject
    private SpiTrigger spiTrigger;

    @Override
    public Object invokeApi(String apiPath, Map<String, Object> jsonParam) throws Throwable {
        Map<FieldDef, String> object = this.dataAccessLayer.getObjectBy(EntityDef.RELEASE, FieldDef.PATH, apiPath);
        ApiInfo apiInfo = new ApiInfo();
        apiInfo.setCallSource(CallSource.Internal);
        apiInfo.setReleaseID(object.get((Object)FieldDef.ID));
        apiInfo.setApiID(object.get((Object)FieldDef.API_ID));
        apiInfo.setMethod(object.get((Object)FieldDef.METHOD));
        apiInfo.setApiPath(object.get((Object)FieldDef.PATH));
        apiInfo.setParameterMap(jsonParam);
        String script = object.get((Object)FieldDef.SCRIPT);
        return this.callService.doCall(apiInfo, param -> script);
    }

    @Override
    public DatawayApi getApiById(String apiId) throws Throwable {
        Map<FieldDef, String> objectBy = this.dataAccessLayer.getObjectBy(EntityDef.INFO, FieldDef.ID, apiId);
        if (objectBy == null) {
            return null;
        }
        return new BasicDatawayApi(objectBy);
    }

    @Override
    public boolean disableApi(final String apiId) {
        Map<FieldDef, String> objectBy = this.dataAccessLayer.getObjectBy(EntityDef.INFO, FieldDef.ID, apiId);
        if (objectBy == null) {
            return true;
        }
        ApiStatusEnum apiStatusEnum = ApiStatusEnum.typeOf(objectBy.get((Object)FieldDef.STATUS));
        if (apiStatusEnum == ApiStatusEnum.Disable || apiStatusEnum == ApiStatusEnum.Delete) {
            return true;
        }
        HashMap<QueryCondition, Object> queryCondition = new HashMap<QueryCondition, Object>(){
            {
                this.put(QueryCondition.ApiId, apiId);
            }
        };
        List<Map<FieldDef, String>> releaseList = this.dataAccessLayer.listObjectBy(EntityDef.RELEASE, (Map<QueryCondition, Object>)queryCondition);
        releaseList = releaseList == null ? Collections.emptyList() : releaseList;
        releaseList.stream().filter(apiRelease -> {
            ApiStatusEnum statusEnum = ApiStatusEnum.typeOf(apiRelease.get((Object)FieldDef.STATUS));
            return statusEnum != ApiStatusEnum.Disable;
        }).forEach(apiRelease -> {
            String releaseId = (String)apiRelease.get((Object)FieldDef.ID);
            apiRelease = this.dataAccessLayer.getObjectBy(EntityDef.RELEASE, FieldDef.ID, releaseId);
            apiRelease.putAll(DatawayUtils.STATUS_UPDATE_TO_DISABLE.get());
            this.dataAccessLayer.updateObject(EntityDef.RELEASE, releaseId, (Map<FieldDef, String>)apiRelease);
        });
        objectBy.putAll(DatawayUtils.STATUS_UPDATE_TO_DISABLE.get());
        return this.dataAccessLayer.updateObject(EntityDef.INFO, apiId, objectBy);
    }

    @Override
    public boolean deleteApi(String apiId) {
        Map<FieldDef, String> objectBy = this.dataAccessLayer.getObjectBy(EntityDef.INFO, FieldDef.ID, apiId);
        if (objectBy == null) {
            return true;
        }
        ApiStatusEnum apiStatusEnum = ApiStatusEnum.typeOf(objectBy.get((Object)FieldDef.STATUS));
        if (apiStatusEnum == ApiStatusEnum.Delete) {
            return true;
        }
        List<Map<FieldDef, String>> releaseList = this.dataAccessLayer.listObjectBy(EntityDef.RELEASE, DatawayUtils.conditionByApiId(apiId));
        releaseList = releaseList == null ? Collections.emptyList() : releaseList;
        releaseList.stream().filter(apiRelease -> {
            ApiStatusEnum statusEnum = ApiStatusEnum.typeOf(apiRelease.get((Object)FieldDef.STATUS));
            return statusEnum != ApiStatusEnum.Delete;
        }).forEach(apiRelease -> {
            String releaseId = (String)apiRelease.get((Object)FieldDef.ID);
            apiRelease.putAll(DatawayUtils.STATUS_UPDATE_TO_DELETE.get());
            this.dataAccessLayer.updateObject(EntityDef.RELEASE, releaseId, (Map<FieldDef, String>)apiRelease);
        });
        return this.dataAccessLayer.deleteObject(EntityDef.INFO, apiId);
    }

    private static final class BasicDatawayApi
    extends HintsSet
    implements DatawayApi {
        private final Map<FieldDef, String> objectBy;

        public BasicDatawayApi(Map<FieldDef, String> objectBy) {
            this.objectBy = objectBy;
            JSONObject prepareHint = JSON.parseObject((String)this.objectBy.get((Object)FieldDef.PREPARE_HINT));
            if (prepareHint != null) {
                prepareHint.forEach((key, value) -> super.setHint(key, value.toString()));
            }
        }

        @Override
        public String getApiID() {
            return this.objectBy.get((Object)FieldDef.ID);
        }

        @Override
        public String getMethod() {
            return this.objectBy.get((Object)FieldDef.METHOD);
        }

        @Override
        public String getApiPath() {
            return this.objectBy.get((Object)FieldDef.PATH);
        }

        @Override
        public Map<String, Object> getOptionMap() {
            return JSON.parseObject((String)this.objectBy.get((Object)FieldDef.OPTION));
        }

        @Override
        public Hints getPrepareHint() {
            return this;
        }
    }
}

