/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.service.schema.types;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.hasor.dataql.domain.DataModel;
import net.hasor.dataql.domain.ListModel;
import net.hasor.dataql.domain.ObjectModel;
import net.hasor.dataql.domain.ValueModel;
import net.hasor.dataway.service.schema.types.AnyType;
import net.hasor.dataway.service.schema.types.ArrayType;
import net.hasor.dataway.service.schema.types.BooleanType;
import net.hasor.dataway.service.schema.types.MapType;
import net.hasor.dataway.service.schema.types.NumberType;
import net.hasor.dataway.service.schema.types.RefType;
import net.hasor.dataway.service.schema.types.StringType;
import net.hasor.dataway.service.schema.types.StrutsType;
import net.hasor.dataway.service.schema.types.Type;
import net.hasor.dataway.service.schema.types.TypeEnum;

public class TypesUtils {
    public static Type extractType(String prefix, AtomicInteger atomicInteger, DataModel atData) {
        if (atData.isObject()) {
            ObjectModel objectModel = (ObjectModel)atData;
            StrutsType strutsType = TypesUtils.autoName(prefix, atomicInteger, new StrutsType());
            List stringList = objectModel.fieldNames();
            LinkedHashMap<String, Type> strutsTypeMap = new LinkedHashMap<String, Type>();
            for (String key : stringList) {
                DataModel fieldTypeDataModel = objectModel.get(key);
                Type type = TypesUtils.extractType(prefix, atomicInteger, fieldTypeDataModel);
                if (type == null) continue;
                strutsTypeMap.put(key, type);
            }
            strutsType.setProperties(strutsTypeMap);
            return strutsType;
        }
        if (atData.isList()) {
            ListModel listModel = (ListModel)atData;
            ArrayType arrayType = TypesUtils.autoName(prefix, atomicInteger, new ArrayType());
            Type lastType = null;
            for (DataModel dataModel : listModel.asOri()) {
                if (lastType != null && lastType.getType() == TypeEnum.Map) break;
                Type type = TypesUtils.extractType(prefix, atomicInteger, dataModel);
                if (type == null) continue;
                if (lastType == null) {
                    lastType = type;
                    continue;
                }
                if (lastType.getType() != type.getType()) {
                    lastType = TypesUtils.autoName(prefix, atomicInteger, new MapType());
                    continue;
                }
                lastType = TypesUtils.mergeType(lastType, type);
            }
            if (lastType == null) {
                lastType = TypesUtils.autoName(prefix, atomicInteger, new AnyType());
            }
            arrayType.setGenericType(lastType);
            return arrayType;
        }
        if (atData.isValue()) {
            ValueModel valueModel = (ValueModel)atData;
            if (valueModel.isNumber()) {
                NumberType numberType = TypesUtils.autoName(prefix, atomicInteger, new NumberType());
                numberType.setDefaultValue(valueModel.asNumber());
                return numberType;
            }
            if (valueModel.isBoolean()) {
                BooleanType booleanType = TypesUtils.autoName(prefix, atomicInteger, new BooleanType());
                booleanType.setDefaultValue(valueModel.asBoolean());
                return booleanType;
            }
            if (valueModel.isString()) {
                StringType stringType = TypesUtils.autoName(prefix, atomicInteger, new StringType());
                stringType.setDefaultValue(valueModel.asString());
                return stringType;
            }
            if (valueModel.isNull()) {
                return TypesUtils.autoName(prefix, atomicInteger, new AnyType());
            }
        }
        if (atData.isUdf()) {
            return null;
        }
        return TypesUtils.autoName(prefix, atomicInteger, new AnyType());
    }

    private static <T extends Type> T autoName(String prefix, AtomicInteger atomicInteger, T type) {
        if (type.getType() == TypeEnum.Array || type.getType() == TypeEnum.Struts || type.getType() == TypeEnum.Ref || type.getType() == TypeEnum.Map) {
            type.setName(prefix + atomicInteger.incrementAndGet());
        }
        return type;
    }

    private static Type mergeType(Type fstType, Type secType) {
        TypeEnum secTypeType;
        TypeEnum fstTypeType = fstType.getType();
        if (fstTypeType == (secTypeType = secType.getType())) {
            if (fstTypeType == TypeEnum.Array) {
                Type fstArrayType = ((ArrayType)fstType).getGenericType();
                Type secArrayType = ((ArrayType)secType).getGenericType();
                Type mergeType = TypesUtils.mergeType(fstArrayType, secArrayType);
                ((ArrayType)fstType).setGenericType(mergeType);
                return fstType;
            }
            if (fstTypeType == TypeEnum.Struts) {
                StrutsType fstMapType = (StrutsType)fstType;
                StrutsType secMapType = (StrutsType)secType;
                Map<String, Type> fstFieldTypeMap = fstMapType.getProperties();
                for (Map.Entry<String, Type> ent : secMapType.getProperties().entrySet()) {
                    String key = ent.getKey();
                    if (!fstFieldTypeMap.containsKey(key)) {
                        fstFieldTypeMap.put(key, ent.getValue());
                        continue;
                    }
                    Type merged = TypesUtils.mergeType(fstFieldTypeMap.get(key), ent.getValue());
                    fstFieldTypeMap.put(key, merged);
                }
                return fstMapType;
            }
        }
        return fstType;
    }

    public static JSONObject toJsonSchema(Type type, boolean useRef) {
        LinkedHashMap<String, JSONObject> defTypes = new LinkedHashMap<String, JSONObject>();
        JSONObject root = TypesUtils.toJsonSchema(defTypes, type, useRef);
        root.put("$schema", (Object)"http://json-schema.org/draft-04/schema#");
        if (!defTypes.isEmpty()) {
            root.put("definitions", defTypes);
        }
        return root;
    }

    private static JSONObject toJsonSchema(Map<String, JSONObject> defTypes, Type type, boolean useRef) {
        if (type.getType() == TypeEnum.String) {
            JSONObject root = new JSONObject();
            root.put("type", (Object)"string");
            return root;
        }
        if (type.getType() == TypeEnum.Boolean) {
            JSONObject root = new JSONObject();
            root.put("type", (Object)"boolean");
            return root;
        }
        if (type.getType() == TypeEnum.Number) {
            JSONObject root = new JSONObject();
            root.put("type", (Object)"number");
            return root;
        }
        if (type.getType() == TypeEnum.Struts) {
            JSONObject root = new JSONObject();
            root.put("type", (Object)"object");
            StrutsType strutsType = (StrutsType)type;
            JSONObject propertiesJson = new JSONObject();
            strutsType.getProperties().forEach((key, propType) -> propertiesJson.put(key, (Object)TypesUtils.toJsonSchema(defTypes, propType, useRef)));
            root.put("properties", (Object)propertiesJson);
            if (useRef) {
                defTypes.put(strutsType.getName(), root);
                JSONObject ref = new JSONObject();
                ref.put("$ref", (Object)("#/definitions/" + strutsType.getName()));
                root = ref;
            }
            return root;
        }
        if (type.getType() == TypeEnum.Array) {
            JSONObject root = new JSONObject();
            root.put("type", (Object)"array");
            Type arrayType = ((ArrayType)type).getGenericType();
            root.put("items", (Object)TypesUtils.toJsonSchema(defTypes, arrayType, useRef));
            return root;
        }
        if (type.getType() == TypeEnum.Ref) {
            JSONObject root = new JSONObject();
            RefType arrayType = (RefType)type;
            root.put("$ref", (Object)("#/definitions/" + arrayType.getRefType()));
            return root;
        }
        if (type.getType() == TypeEnum.Map) {
            JSONObject root = new JSONObject();
            root.put("type", (Object)"object");
            return root;
        }
        JSONObject root = new JSONObject();
        root.put("type", (Object)new JSONArray(){
            {
                this.add("string");
                this.add("boolean");
                this.add("number");
                this.add("object");
                this.add("array");
                this.add("null");
            }
        });
        return root;
    }
}

