/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.web;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.hasor.dataway.authorization.PermissionType;
import net.hasor.dataway.authorization.RefAuthorization;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.config.MappingToUrl;
import net.hasor.dataway.config.Result;
import net.hasor.dataway.dal.ApiStatusEnum;
import net.hasor.dataway.dal.EntityDef;
import net.hasor.dataway.dal.FieldDef;
import net.hasor.dataway.web.BasicController;
import net.hasor.web.annotation.Get;
import net.hasor.web.annotation.QueryParameter;
import net.hasor.web.objects.JsonRenderEngine;
import net.hasor.web.render.RenderType;

@MappingToUrl(value="/api/api-history")
@RefAuthorization(value=PermissionType.ApiHistory)
@RenderType(value="json", engineType=JsonRenderEngine.class)
public class ApiHistoryListController
extends BasicController {
    @Get
    public Result<List<Map<String, Object>>> apiHistory(@QueryParameter(value="id") String apiId) {
        List<Map<FieldDef, String>> releaseList = this.dataAccessLayer.listObjectBy(EntityDef.RELEASE, DatawayUtils.conditionByApiId(apiId));
        releaseList = releaseList == null ? Collections.emptyList() : releaseList;
        final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List dataList = releaseList.parallelStream().filter(releaseItem -> {
            if (releaseItem == null) {
                return false;
            }
            ApiStatusEnum statusEnum = ApiStatusEnum.typeOf(releaseItem.get((Object)FieldDef.STATUS));
            return statusEnum != null && statusEnum != ApiStatusEnum.Delete;
        }).map(releaseItem -> new HashMap<String, Object>(){
            {
                this.put("historyId", releaseItem.get((Object)FieldDef.ID));
                this.put("status", ApiStatusEnum.typeOf(releaseItem.get((Object)FieldDef.STATUS)).typeNum());
                this.put("time", dateFormat.format(new Date(Long.parseLong((String)releaseItem.get((Object)FieldDef.RELEASE_TIME)))));
            }
        }).collect(Collectors.toList());
        return Result.of(dataList);
    }
}

