/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.web;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.hasor.dataway.authorization.PermissionType;
import net.hasor.dataway.authorization.RefAuthorization;
import net.hasor.dataway.config.MappingToUrl;
import net.hasor.dataway.config.Result;
import net.hasor.dataway.dal.ApiStatusEnum;
import net.hasor.dataway.dal.ApiTypeEnum;
import net.hasor.dataway.dal.EntityDef;
import net.hasor.dataway.dal.FieldDef;
import net.hasor.dataway.dal.HeaderData;
import net.hasor.dataway.web.BasicController;
import net.hasor.web.annotation.Get;
import net.hasor.web.annotation.QueryParameter;
import net.hasor.web.objects.JsonRenderEngine;
import net.hasor.web.render.RenderType;

@MappingToUrl(value="/api/api-info")
@RefAuthorization(value=PermissionType.ApiInfo)
@RenderType(value="json", engineType=JsonRenderEngine.class)
public class ApiInfoController
extends BasicController {
    @Get
    public Result<Object> apiInfo(@QueryParameter(value="id") String apiId) {
        Map<FieldDef, String> object = this.dataAccessLayer.getObjectBy(EntityDef.INFO, FieldDef.ID, apiId);
        if (object == null) {
            return Result.of(404, "not found Api.");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("id", object.get((Object)FieldDef.ID));
        hashMap.put("select", object.get((Object)FieldDef.METHOD));
        hashMap.put("path", object.get((Object)FieldDef.PATH));
        hashMap.put("status", ApiStatusEnum.typeOf(object.get((Object)FieldDef.STATUS)).typeNum());
        hashMap.put("codeType", ApiTypeEnum.typeOf(object.get((Object)FieldDef.TYPE)).typeString());
        hashMap.put("requestBody", object.get((Object)FieldDef.REQ_BODY_SAMPLE));
        List headerData = JSON.parseArray((String)object.get((Object)FieldDef.REQ_HEADER_SAMPLE), HeaderData.class);
        headerData = headerData == null ? Collections.emptyList() : headerData.parallelStream().filter(HeaderData::isChecked).collect(Collectors.toList());
        hashMap.put("headerData", headerData);
        return Result.of(hashMap);
    }
}

