/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.hasor.dataway.authorization.PermissionType;
import net.hasor.dataway.authorization.RefAuthorization;
import net.hasor.dataway.config.MappingToUrl;
import net.hasor.dataway.config.Result;
import net.hasor.dataway.dal.ApiStatusEnum;
import net.hasor.dataway.dal.EntityDef;
import net.hasor.dataway.dal.FieldDef;
import net.hasor.dataway.web.BasicController;
import net.hasor.web.annotation.Get;
import net.hasor.web.objects.JsonRenderEngine;
import net.hasor.web.render.RenderType;

@MappingToUrl(value="/api/api-list")
@RefAuthorization(value=PermissionType.ApiList)
@RenderType(value="json", engineType=JsonRenderEngine.class)
public class ApiListController
extends BasicController {
    @Get
    public Result<List<Map<String, Object>>> apiList() {
        List<Map<FieldDef, String>> infoList = this.dataAccessLayer.listObjectBy(EntityDef.INFO, ApiListController.emptyCondition());
        infoList = infoList == null ? Collections.emptyList() : infoList;
        List dataList = infoList.parallelStream().map(infoMap -> new HashMap<String, Object>(){
            {
                this.put("id", infoMap.get((Object)FieldDef.ID));
                this.put("checked", false);
                this.put("select", infoMap.get((Object)FieldDef.METHOD));
                this.put("path", infoMap.get((Object)FieldDef.PATH));
                this.put("status", ApiStatusEnum.typeOf(infoMap.get((Object)FieldDef.STATUS)).typeNum());
                this.put("comment", infoMap.get((Object)FieldDef.COMMENT));
            }
        }).collect(Collectors.toList());
        return Result.of(dataList);
    }
}

