/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.web;

import java.io.InputStream;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import net.hasor.core.AppContext;
import net.hasor.core.BindInfo;
import net.hasor.core.Inject;
import net.hasor.core.setting.SettingNode;
import net.hasor.core.spi.BindInfoAware;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.config.GlobalConfig;
import net.hasor.dataway.config.MappingToUrl;
import net.hasor.dataway.config.Result;
import net.hasor.dataway.config.UiConfig;
import net.hasor.dataway.web.BasicController;
import net.hasor.utils.ResourcesUtils;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.annotation.Get;
import net.hasor.web.objects.JsonRenderEngine;
import net.hasor.web.render.RenderType;

@MappingToUrl(value="/api/global-config")
@RenderType(value="json", engineType=JsonRenderEngine.class)
public class GlobalConfigController
extends BasicController
implements UiConfig,
BindInfoAware {
    private static final String DATAWAY_VERSION;
    @Inject
    private AppContext appContext;
    private String apiBaseUri;
    private String uiBaseUri;
    private GlobalConfig globalConfig;

    private static String allLocalMac() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        HashSet<String> macPool = new HashSet<String>();
        while (interfaces.hasMoreElements()) {
            NetworkInterface nextElement = interfaces.nextElement();
            byte[] hardwareAddress = nextElement.getHardwareAddress();
            if (hardwareAddress == null) continue;
            StringBuilder strBuilder = new StringBuilder();
            for (int i = 0; i < hardwareAddress.length; ++i) {
                String str = Integer.toHexString(hardwareAddress[i] & 0xFF);
                strBuilder.append(str.length() == 1 ? "0" + str : str);
            }
            macPool.add(strBuilder.toString());
        }
        return StringUtils.join((Object[])macPool.toArray(), (String)",").toUpperCase();
    }

    public void setBindInfo(BindInfo<?> bindInfo) {
        this.uiBaseUri = (String)bindInfo.getMetaData("KEY_DATAWAY_UI_BASE_URI");
        this.apiBaseUri = (String)bindInfo.getMetaData("KEY_DATAWAY_API_BASE_URI");
    }

    @PostConstruct
    public void initController() {
        this.globalConfig = (GlobalConfig)this.appContext.getInstance(GlobalConfig.class);
        SettingNode settingNode = this.appContext.getEnvironment().getSettings().getNode("hasor.dataway.globalConfig");
        if (settingNode != null) {
            Map globalConfigMap = settingNode.toMap();
            globalConfigMap.forEach((key, val) -> {
                if (!this.globalConfig.containsKey(key)) {
                    this.globalConfig.put(key, val);
                }
            });
        }
        this.globalConfig.put("API_BASE_URL", this.apiBaseUri);
    }

    @Get
    public Result<Map<String, String>> globalConfig(Invoker invoker) {
        String contextPath = DatawayUtils.getDwContextPath(invoker, null);
        this.globalConfig.put("CONTEXT_PATH", contextPath);
        return Result.of(this.globalConfig);
    }

    static {
        String version = null;
        try {
            InputStream inputStream = ResourcesUtils.getResourceAsStream((String)"/META-INF/maven/net.hasor/hasor-dataway/pom.properties");
            Properties properties = new Properties();
            properties.load(inputStream);
            version = properties.getProperty("version");
        }
        catch (Exception e) {
            version = "4.2.2";
        }
        DATAWAY_VERSION = version;
    }
}

